/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling.implementation;

import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import reactor.core.publisher.Mono;

public final class PollingUtils {
    public static Mono<BinaryData> serializeResponse(Object response, ObjectSerializer serializer) {
        if (response instanceof BinaryData) {
            return Mono.just((Object)((BinaryData)response));
        }
        return BinaryData.fromObjectAsync(response, serializer);
    }

    public static <T> Mono<T> deserializeResponse(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (TypeUtil.isTypeOrSubTypeOf(BinaryData.class, typeReference.getJavaType())) {
            return Mono.just((Object)binaryData);
        }
        return binaryData.toObjectAsync(typeReference, serializer);
    }

    public static <T> Mono<T> convertResponse(Object response, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (response == null) {
            return Mono.empty();
        }
        if (TypeUtil.isTypeOrSubTypeOf(response.getClass(), typeReference.getJavaType())) {
            return Mono.just((Object)response);
        }
        return PollingUtils.serializeResponse(response, serializer).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, serializer, typeReference));
    }

    private PollingUtils() {
    }
}

