/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.NoopConfiguration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Configuration
implements Cloneable {
    public static final Configuration NONE = new NoopConfiguration();
    public static final String PROPERTY_HTTP_PROXY = "HTTP_PROXY";
    public static final String PROPERTY_HTTPS_PROXY = "HTTPS_PROXY";
    public static final String PROPERTY_NO_PROXY = "NO_PROXY";
    public static final String PROPERTY_MSI_ENDPOINT = "MSI_ENDPOINT";
    public static final String PROPERTY_MSI_SECRET = "MSI_SECRET";
    public static final String PROPERTY_AZURE_SUBSCRIPTION_ID = "AZURE_SUBSCRIPTION_ID";
    public static final String PROPERTY_AZURE_USERNAME = "AZURE_USERNAME";
    public static final String PROPERTY_AZURE_PASSWORD = "AZURE_PASSWORD";
    public static final String PROPERTY_AZURE_CLIENT_ID = "AZURE_CLIENT_ID";
    public static final String PROPERTY_AZURE_CLIENT_SECRET = "AZURE_CLIENT_SECRET";
    public static final String PROPERTY_AZURE_TENANT_ID = "AZURE_TENANT_ID";
    public static final String PROPERTY_AZURE_RESOURCE_GROUP = "AZURE_RESOURCE_GROUP";
    public static final String PROPERTY_AZURE_CLOUD = "AZURE_CLOUD";
    public static final String PROPERTY_AZURE_TELEMETRY_DISABLED = "AZURE_TELEMETRY_DISABLED";
    public static final String PROPERTY_AZURE_LOG_LEVEL = "AZURE_LOG_LEVEL";
    public static final String PROPERTY_AZURE_TRACING_DISABLED = "AZURE_TRACING_DISABLED";
    private static final String[] DEFAULT_CONFIGURATIONS = new String[]{"HTTP_PROXY", "HTTPS_PROXY", "NO_PROXY", "MSI_ENDPOINT", "MSI_SECRET", "AZURE_SUBSCRIPTION_ID", "AZURE_USERNAME", "AZURE_PASSWORD", "AZURE_CLIENT_ID", "AZURE_CLIENT_SECRET", "AZURE_TENANT_ID", "AZURE_RESOURCE_GROUP", "AZURE_CLOUD", "AZURE_TELEMETRY_DISABLED", "AZURE_LOG_LEVEL", "AZURE_TRACING_DISABLED"};
    private static final Configuration GLOBAL_CONFIGURATION = new Configuration();
    private static final String LOADED_FROM_RUNTIME = "Loaded {} from runtime parameters.";
    private static final String LOADED_FROM_ENVIRONMENT = "Loaded {} from environment variables.";
    private final ConcurrentMap<String, String> configurations;
    private boolean loadedBaseConfigurations = false;

    public Configuration() {
        this.configurations = new ConcurrentHashMap<String, String>();
    }

    private Configuration(ConcurrentMap<String, String> configurations) {
        this.configurations = new ConcurrentHashMap<String, String>(configurations);
    }

    public static Configuration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String get(String name) {
        return this.getOrLoad(name);
    }

    public <T> T get(String name, T defaultValue) {
        return this.convertOrDefault(this.getOrLoad(name), defaultValue);
    }

    public <T> T get(String name, Function<String, T> converter) {
        String value = this.getOrLoad(name);
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        return converter.apply(value);
    }

    private String getOrLoad(String name) {
        this.loadBaseConfigurations();
        if (PROPERTY_AZURE_TRACING_DISABLED.equalsIgnoreCase(name)) {
            this.load(name);
        }
        if (this.configurations.containsKey(name)) {
            return (String)this.configurations.get(name);
        }
        return this.load(name);
    }

    private String load(String name) {
        if (this.loadFrom(name, System::getProperty, LOADED_FROM_RUNTIME) || this.loadFrom(name, System::getenv, LOADED_FROM_ENVIRONMENT)) {
            return (String)this.configurations.get(name);
        }
        return null;
    }

    public Configuration put(String name, String value) {
        this.configurations.put(name, value);
        return this;
    }

    public String remove(String name) {
        return (String)this.configurations.remove(name);
    }

    public boolean contains(String name) {
        return this.configurations.containsKey(name);
    }

    public Configuration clone() {
        this.loadBaseConfigurations();
        Configuration clone = new Configuration(this.configurations);
        clone.loadedBaseConfigurations = true;
        return clone;
    }

    private <T> T convertOrDefault(String value, T defaultValue) {
        if (CoreUtils.isNullOrEmpty(value)) {
            return defaultValue;
        }
        Object convertedValue = defaultValue instanceof Byte ? Byte.valueOf(Byte.parseByte(value)) : (defaultValue instanceof Short ? Short.valueOf(Short.parseShort(value)) : (defaultValue instanceof Integer ? Integer.valueOf(Integer.parseInt(value)) : (defaultValue instanceof Long ? Long.valueOf(Long.parseLong(value)) : (defaultValue instanceof Float ? Float.valueOf(Float.parseFloat(value)) : (defaultValue instanceof Double ? Double.valueOf(Double.parseDouble(value)) : (defaultValue instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : value))))));
        return (T)convertedValue;
    }

    private boolean loadFrom(String name, Function<String, String> loader, String logMessage) {
        String value = loader.apply(name);
        if (value == null) {
            return false;
        }
        if (value.equals(this.configurations.get(name))) {
            return true;
        }
        this.configurations.put(name, value);
        return true;
    }

    private void loadBaseConfigurations() {
        if (this.loadedBaseConfigurations) {
            return;
        }
        for (String config : DEFAULT_CONFIGURATIONS) {
            if (this.configurations.containsKey(config)) continue;
            this.load(config);
        }
        this.loadedBaseConfigurations = true;
    }
}

