/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Flux;

public class IterableStream<T>
implements Iterable<T> {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final IterableStream<Object> EMPTY = new IterableStream(new ArrayList());
    private final ClientLogger logger = new ClientLogger(IterableStream.class);
    private final Flux<T> flux;
    private final Iterable<T> iterable;

    public IterableStream(Flux<T> flux) {
        this.flux = Objects.requireNonNull(flux, "'flux' cannot be null.");
        this.iterable = null;
    }

    public IterableStream(Iterable<T> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "'iterable' cannot be null.");
        this.flux = null;
    }

    public Stream<T> stream() {
        if (this.flux != null) {
            return this.flux.toStream(1);
        }
        if (this.iterable != null) {
            return StreamSupport.stream(this.iterable.spliterator(), false);
        }
        this.logger.warning("IterableStream was not initialized with Iterable or Flux, returning empty stream.", new Object[0]);
        return Stream.empty();
    }

    @Override
    public Iterator<T> iterator() {
        if (this.flux != null) {
            return this.flux.toIterable(1).iterator();
        }
        if (this.iterable != null) {
            return this.iterable.iterator();
        }
        this.logger.warning("IterableStream was not initialized with Iterable or Flux, returning empty iterator.", new Object[0]);
        return Collections.emptyIterator();
    }

    public static <T> IterableStream<T> of(Iterable<T> iterable) {
        if (iterable == null) {
            return EMPTY;
        }
        return new IterableStream<T>(iterable);
    }
}

