/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class HttpResponseBodyDecoder {
    private static final Map<Type, Boolean> RETURN_TYPE_DECODEABLE_MAP = new ConcurrentHashMap<Type, Boolean>();
    private static final ClientLogger LOGGER = new ClientLogger(HttpResponseBodyDecoder.class);

    static Object decodeByteArray(byte[] body, HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), decodeData)) {
            try {
                return HttpResponseBodyDecoder.deserializeBody(body, decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType(), null, serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
            }
            catch (MalformedValueException | IOException ex) {
                LOGGER.warning("Failed to deserialize the error entity.", ex);
                return null;
            }
        }
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (!HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType())) {
            return null;
        }
        byte[] bodyAsByteArray = body == null ? httpResponse.getBodyAsBinaryData().toBytes() : body;
        try {
            return HttpResponseBodyDecoder.deserializeBody(bodyAsByteArray, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.getReturnValueWireType(), serializer, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
        }
        catch (MalformedValueException e) {
            throw new HttpResponseException("HTTP response has a malformed body.", httpResponse, e);
        }
        catch (IOException e) {
            throw new HttpResponseException("Deserialization Failed.", httpResponse, e);
        }
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), decodeData)) {
            return decodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType();
        }
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        return HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData.getReturnType()) ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData) : null;
    }

    static boolean isErrorStatus(int statusCode, HttpResponseDecodeData decodeData) {
        return !decodeData.isExpectedResponseStatusCode(statusCode);
    }

    private static Object deserializeBody(byte[] value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        if (wireType == null) {
            return serializer.deserialize(value, resultType, encoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(wireType, Page.class)) {
            return HttpResponseBodyDecoder.deserializePage(value, resultType, wireType, serializer, encoding);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = serializer.deserialize(value, wireResponseType, encoding);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(wireType);
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return DateTimeRfc1123.class;
            }
            if (wireType == UnixTime.class) {
                return UnixTime.class;
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), wireResponseElementType);
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
                Type resultValueType = typeArguments[1];
                Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
            }
        }
        return resultType;
    }

    private static Object deserializePage(byte[] value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        Type wireResponseType = wireType == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, new Type[]{resultType}) : wireType;
        return serializer.deserialize(value, wireResponseType, encoding);
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                return ((Base64Url)wireResponse).decodedBytes();
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return ((DateTimeRfc1123)wireResponse).getDateTime();
            }
            if (wireType == UnixTime.class) {
                return ((UnixTime)wireResponse).getDateTime();
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                return wireResponseList;
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseEntries = wireResponseMap.entrySet();
                for (Map.Entry wireResponseEntry : wireResponseEntries) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseEntry.getValue();
                    if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put((String)wireResponseEntry.getKey(), resultValue);
                }
                return wireResponseMap;
            }
        }
        return wireResponse;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Mono.class)) {
            token = TypeUtil.getTypeArgument(token);
        }
        if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
            token = TypeUtil.getRestResponseBodyType(token);
        }
        return token;
    }

    public static boolean isReturnTypeDecodable(Type returnType) {
        if (returnType == null) {
            return false;
        }
        return RETURN_TYPE_DECODEABLE_MAP.computeIfAbsent(returnType, type -> !TypeUtil.isTypeOrSubTypeOf(type = HttpResponseBodyDecoder.unwrapReturnType(type), BinaryData.class) && !TypeUtil.isTypeOrSubTypeOf(type, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(type, ByteBuffer.class) && !TypeUtil.isTypeOrSubTypeOf(type, InputStream.class) && !TypeUtil.isTypeOrSubTypeOf(type, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(type, Void.class));
    }

    public static boolean shouldEagerlyReadResponse(Type returnType) {
        if (returnType == null) {
            return false;
        }
        return HttpResponseBodyDecoder.isReturnTypeDecodable(returnType) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class);
    }

    private static Type unwrapReturnType(Type returnType) {
        if (TypeUtil.isTypeOrSubTypeOf(returnType, ResponseBase.class)) {
            returnType = HttpResponseBodyDecoder.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == ResponseBase.class);
            return HttpResponseBodyDecoder.unwrapReturnType(TypeUtil.getTypeArguments(returnType)[1]);
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Response.class)) {
            returnType = HttpResponseBodyDecoder.walkSuperTypesUntil(returnType, type -> TypeUtil.typeImplementsInterface(type, Response.class));
            return HttpResponseBodyDecoder.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            returnType = HttpResponseBodyDecoder.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == Mono.class);
            return HttpResponseBodyDecoder.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Flux.class)) {
            returnType = HttpResponseBodyDecoder.walkSuperTypesUntil(returnType, type -> TypeUtil.getRawClass(type) == Flux.class);
            return HttpResponseBodyDecoder.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        return returnType;
    }

    private static Type walkSuperTypesUntil(Type type, Predicate<Type> untilChecker) {
        while (!untilChecker.test(type)) {
            type = TypeUtil.getSuperType(type);
        }
        return type;
    }

    private static void ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.getRequest());
        Objects.requireNonNull(httpResponse.getRequest().getHttpMethod());
    }
}

