/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.ProgressListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ProgressReporter {
    private final ProgressListener progressListener;
    private final ProgressReporter parent;
    private static final AtomicLongFieldUpdater<ProgressReporter> PROGRESS_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(ProgressReporter.class, "progress");
    private volatile long progress;

    private ProgressReporter(ProgressListener progressListener) {
        this.progressListener = Objects.requireNonNull(progressListener, "'progressListener' must not be null");
        this.parent = null;
    }

    private ProgressReporter(ProgressReporter parent) {
        this.parent = Objects.requireNonNull(parent, "'parent' must not be null");
        this.progressListener = null;
    }

    public static ProgressReporter withProgressListener(ProgressListener progressListener) {
        return new ProgressReporter(progressListener);
    }

    public ProgressReporter createChild() {
        return new ProgressReporter(this);
    }

    public void reset() {
        long accumulated = PROGRESS_ATOMIC_UPDATER.getAndSet(this, 0L);
        if (this.parent != null) {
            this.parent.reportProgress(-1L * accumulated);
        }
        if (this.progressListener != null) {
            this.progressListener.handleProgress(0L);
        }
    }

    public void reportProgress(long progress) {
        long totalProgress = PROGRESS_ATOMIC_UPDATER.addAndGet(this, progress);
        if (this.parent != null) {
            this.parent.reportProgress(progress);
        }
        if (this.progressListener != null) {
            this.progressListener.handleProgress(totalProgress);
        }
    }
}

