/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.BasicAuthenticationCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.net.URL;
import java.time.OffsetDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class CredentialsTests {
    @Test
    public void basicCredentialsTest() throws Exception {
        BasicAuthenticationCredential credentials = new BasicAuthenticationCredential("user", "pass");
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Basic dXNlcjpwYXNz", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{(context, next) -> credentials.getToken(new TokenRequestContext().addScopes(new String[]{"scope./default"})).flatMap(token -> {
            context.getHttpRequest().getHeaders().put("Authorization", "Basic " + token.getToken());
            return next.process();
        }), auditorPolicy}).build();
        HttpRequest request = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        pipeline.send(request).block();
    }

    @Test
    public void tokenCredentialTest() throws Exception {
        TokenCredential credentials = request -> Mono.just((Object)new AccessToken("this_is_a_token", OffsetDateTime.MAX));
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Bearer this_is_a_token", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new BearerTokenAuthenticationPolicy(credentials, new String[]{"scope./default"}), auditorPolicy}).build();
        HttpRequest request2 = new HttpRequest(HttpMethod.GET, new URL("https://localhost"));
        pipeline.send(request2).block();
    }

    @Test
    public void tokenCredentialHttpSchemeTest() throws Exception {
        TokenCredential credentials = request -> Mono.just((Object)new AccessToken("this_is_a_token", OffsetDateTime.MAX));
        HttpPipelinePolicy auditorPolicy = (context, next) -> {
            String headerValue = context.getHttpRequest().getHeaders().getValue("Authorization");
            Assertions.assertEquals((Object)"Bearer this_is_a_token", (Object)headerValue);
            return next.process();
        };
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new BearerTokenAuthenticationPolicy(credentials, new String[]{"scope./default"}), auditorPolicy}).build();
        HttpRequest request2 = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        StepVerifier.create((Publisher)pipeline.send(request2)).expectErrorMessage("token credentials require a URL using the HTTPS protocol scheme").verify();
    }
}

