/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.SimpleTokenCache;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class TokenCacheTests {
    private static final Random RANDOM = new Random();

    @Test
    public void testOnlyOneThreadRefreshesToken() throws Exception {
        SimpleTokenCache cache = new SimpleTokenCache(() -> this.incrementalRemoteGetTokenAsync(new AtomicInteger(1)));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicLong maxMillis = new AtomicLong(0L);
        Flux.range((int)1, (int)10).flatMap(i -> Mono.just((Object)OffsetDateTime.now()).subscribeOn(Schedulers.newParallel((String)"pool", (int)10)).flatMap(start -> cache.getToken().map(t -> Duration.between(start, OffsetDateTime.now()).toMillis()).doOnNext(millis -> {
            if (millis > maxMillis.get()) {
                maxMillis.set((long)millis);
            }
        }))).doOnComplete(latch::countDown).subscribe();
        latch.await();
        Assertions.assertTrue((maxMillis.get() > 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((maxMillis.get() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testLongRunningWontOverflow() throws Exception {
        AtomicLong refreshes = new AtomicLong(0L);
        SimpleTokenCache cache = new SimpleTokenCache(() -> {
            refreshes.incrementAndGet();
            return this.remoteGetTokenThatExpiresSoonAsync(1000L, 0L);
        });
        CountDownLatch latch = new CountDownLatch(1);
        Flux.interval((Duration)Duration.ofMillis(100L)).take(100L).flatMap(i -> Mono.just((Object)OffsetDateTime.now()).subscribeOn(Schedulers.newParallel((String)"pool", (int)100)).flatMap(start -> cache.getToken().map(t -> Duration.between(start, OffsetDateTime.now()).toMillis()).doOnNext(millis -> {}))).doOnComplete(latch::countDown).subscribe();
        latch.await();
        Assertions.assertTrue((refreshes.get() <= 11L ? 1 : 0) != 0);
    }

    private Mono<AccessToken> remoteGetTokenAsync(long delayInMillis) {
        return Mono.delay((Duration)Duration.ofMillis(delayInMillis)).map(l -> new Token(Integer.toString(RANDOM.nextInt(100))));
    }

    private Mono<AccessToken> remoteGetTokenThatExpiresSoonAsync(long delayInMillis, long validityInMillis) {
        return Mono.delay((Duration)Duration.ofMillis(delayInMillis)).map(l -> new Token(Integer.toString(RANDOM.nextInt(100)), validityInMillis));
    }

    private Mono<AccessToken> incrementalRemoteGetTokenAsync(AtomicInteger latency) {
        return Mono.delay((Duration)Duration.ofSeconds(latency.getAndIncrement())).map(l -> new Token(Integer.toString(RANDOM.nextInt(100))));
    }

    private static class Token
    extends AccessToken {
        private String token;
        private OffsetDateTime expiry;

        public String getToken() {
            return this.token;
        }

        Token(String token) {
            this(token, 5000L);
        }

        Token(String token, long validityInMillis) {
            super(token, OffsetDateTime.now().plus(Duration.ofMillis(validityInMillis)));
            this.token = token;
            this.expiry = OffsetDateTime.now().plus(Duration.ofMillis(validityInMillis));
        }

        public OffsetDateTime getExpiresAt() {
            return this.expiry;
        }

        public boolean isExpired() {
            return OffsetDateTime.now().isAfter(this.expiry);
        }
    }
}

