/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.HostPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HostPolicyTests {
    @Test
    public void withNoPort() throws MalformedURLException {
        HttpPipeline pipeline = HostPolicyTests.createPipeline("localhost", "ftp://localhost");
        pipeline.send(HostPolicyTests.createHttpRequest("ftp://www.example.com")).block();
    }

    @Test
    public void withPort() throws MalformedURLException {
        HttpPipeline pipeline = HostPolicyTests.createPipeline("localhost", "ftp://localhost:1234");
        pipeline.send(HostPolicyTests.createHttpRequest("ftp://www.example.com:1234"));
    }

    private static HttpPipeline createPipeline(String host, String expectedUrl) {
        return new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient()).policies(new HttpPipelinePolicy[]{new HostPolicy(host), (context, next) -> {
            Assertions.assertEquals((Object)expectedUrl, (Object)context.getHttpRequest().getUrl().toString());
            return next.process();
        }}).build();
    }

    private static HttpRequest createHttpRequest(String url) throws MalformedURLException {
        return new HttpRequest(HttpMethod.GET, new URL(url));
    }
}

