/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class HttpLoggingPolicyTests {
    private static final String REDACTED = "REDACTED";
    private static final Context CONTEXT = new Context((Object)"caller-method", (Object)HttpLoggingPolicyTests.class.getName());
    private String originalLogLevel;
    private PrintStream originalSystemOut;
    private ByteArrayOutputStream logCaptureStream;

    @BeforeEach
    public void prepareForTest() {
        this.originalLogLevel = Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        Configuration.getGlobalConfiguration().put("AZURE_LOG_LEVEL", String.valueOf(LogLevel.INFORMATIONAL.getLogLevel()));
        this.originalSystemOut = System.out;
        this.logCaptureStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.logCaptureStream));
    }

    @AfterEach
    public void cleanupAfterTest() throws IOException {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.originalLogLevel)) {
            Configuration.getGlobalConfiguration().remove("AZURE_LOG_LEVEL");
        } else {
            Configuration.getGlobalConfiguration().put("AZURE_LOG_LEVEL", this.originalLogLevel);
        }
        System.setOut(this.originalSystemOut);
        this.logCaptureStream.close();
    }

    @ParameterizedTest
    @MethodSource(value={"redactQueryParametersSupplier"})
    @ResourceLock(value="SYSTEM_OUT")
    public void redactQueryParameters(String requestUrl, String expectedQueryString, Set<String> allowedQueryParameters) {
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BASIC).setAllowedQueryParamNames(allowedQueryParameters))}).httpClient((HttpClient)new NoOpHttpClient()).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.POST, requestUrl), CONTEXT)).verifyComplete();
        String logString = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)logString.contains(expectedQueryString));
    }

    private static Stream<Arguments> redactQueryParametersSupplier() {
        String requestUrl = "https://localhost?sensitiveQueryParameter=sensitiveValue&queryParameter=value";
        String expectedFormat = "sensitiveQueryParameter=%s&queryParameter=%s";
        String fullyRedactedQueryString = String.format(expectedFormat, REDACTED, REDACTED);
        String sensitiveRedactionQueryString = String.format(expectedFormat, REDACTED, "value");
        String fullyAllowedQueryString = String.format(expectedFormat, "sensitiveValue", "value");
        HashSet<String> allQueryParameters = new HashSet<String>();
        allQueryParameters.add("sensitiveQueryParameter");
        allQueryParameters.add("queryParameter");
        return Stream.of(Arguments.of((Object[])new Object[]{requestUrl, fullyRedactedQueryString, new HashSet()}), Arguments.of((Object[])new Object[]{requestUrl, sensitiveRedactionQueryString, Collections.singleton("queryParameter")}), Arguments.of((Object[])new Object[]{requestUrl, fullyAllowedQueryString, allQueryParameters}));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"validateLoggingDoesNotConsumeSupplier"})
    @ResourceLock(value="SYSTEM_OUT")
    public void validateLoggingDoesNotConsumeRequest(Flux<ByteBuffer> stream, byte[] data, int contentLength) throws MalformedURLException {
        URL requestUrl = new URL("https://test.com");
        HttpHeaders requestHeaders = new HttpHeaders().put("Content-Type", "application/json").put("Content-Length", Integer.toString(contentLength));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY))}).httpClient(request -> FluxUtil.collectBytesInByteBufferStream((Flux)request.getBody()).doOnSuccess(bytes -> Assertions.assertArrayEquals((byte[])data, (byte[])bytes)).then(Mono.empty())).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.POST, requestUrl, requestHeaders, stream), CONTEXT)).verifyComplete();
        String logString = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(logString);
        Assertions.assertTrue((boolean)logString.contains(new String(data, StandardCharsets.UTF_8)));
    }

    @ParameterizedTest(name="[{index}] {displayName}")
    @MethodSource(value={"validateLoggingDoesNotConsumeSupplier"})
    @ResourceLock(value="SYSTEM_OUT")
    public void validateLoggingDoesNotConsumeResponse(Flux<ByteBuffer> stream, byte[] data, int contentLength) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, "https://test.com");
        HttpHeaders responseHeaders = new HttpHeaders().put("Content-Type", "application/json").put("Content-Length", Integer.toString(contentLength));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY))}).httpClient(ignored -> Mono.just((Object)((Object)new MockHttpResponse(ignored, responseHeaders, stream)))).build();
        StepVerifier.create((Publisher)pipeline.send(request, CONTEXT)).assertNext(response -> StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)response.getBody())).assertNext(bytes -> Assertions.assertArrayEquals((byte[])data, (byte[])bytes)).verifyComplete()).verifyComplete();
        String logString = new String(this.logCaptureStream.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(logString);
        Assertions.assertTrue((boolean)logString.contains(new String(data, StandardCharsets.UTF_8)));
    }

    private static Stream<Arguments> validateLoggingDoesNotConsumeSupplier() {
        byte[] data = "this is a test".getBytes(StandardCharsets.UTF_8);
        byte[] repeatingData = new byte[data.length * 3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(data, 0, repeatingData, i * data.length, data.length);
        }
        return Stream.of(Arguments.of((Object[])new Object[]{Flux.just((Object)ByteBuffer.wrap(data)), data, data.length}), Arguments.of((Object[])new Object[]{Flux.fromStream(Stream.of(ByteBuffer.wrap(data))), data, data.length}), Arguments.of((Object[])new Object[]{Flux.just((Object)ByteBuffer.wrap(data)).publish().autoConnect(), data, data.length}), Arguments.of((Object[])new Object[]{Flux.fromArray((Object[])new ByteBuffer[]{ByteBuffer.wrap(data), ByteBuffer.wrap(data), ByteBuffer.wrap(data)}), repeatingData, repeatingData.length}), Arguments.of((Object[])new Object[]{Flux.fromStream(Stream.of(ByteBuffer.wrap(data), ByteBuffer.wrap(data), ByteBuffer.wrap(data))), repeatingData, repeatingData.length}), Arguments.of((Object[])new Object[]{Flux.just((Object[])new ByteBuffer[]{ByteBuffer.wrap(data), ByteBuffer.wrap(data), ByteBuffer.wrap(data)}).publish().autoConnect(), repeatingData, repeatingData.length}));
    }

    private static class MockHttpResponse
    extends HttpResponse {
        private final HttpHeaders headers;
        private final Flux<ByteBuffer> body;

        MockHttpResponse(HttpRequest request, HttpHeaders headers, Flux<ByteBuffer> body) {
            super(request);
            this.headers = headers;
            this.body = body;
        }

        public int getStatusCode() {
            return 200;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return this.body;
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return FluxUtil.collectBytesInByteBufferStream(this.body);
        }

        public Mono<String> getBodyAsString() {
            return this.getBodyAsString(StandardCharsets.UTF_8);
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
        }
    }
}

