/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestIdPolicyTests {
    private final HttpResponse mockResponse = new HttpResponse(null){

        public int getStatusCode() {
            return 500;
        }

        public String getHeaderValue(String name) {
            return null;
        }

        public HttpHeaders getHeaders() {
            return new HttpHeaders();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    };
    private static final String REQUEST_ID_HEADER = "x-ms-client-request-id";

    @Test
    public void newRequestIdForEachCall() throws Exception {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            String firstRequestId = null;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                if (this.firstRequestId != null) {
                    String newRequestId = request.getHeaders().getValue(RequestIdPolicyTests.REQUEST_ID_HEADER);
                    Assertions.assertNotNull((Object)newRequestId);
                    Assertions.assertNotEquals((Object)newRequestId, (Object)this.firstRequestId);
                }
                this.firstRequestId = request.getHeaders().getValue(RequestIdPolicyTests.REQUEST_ID_HEADER);
                if (this.firstRequestId == null) {
                    Assertions.fail();
                }
                return Mono.just((Object)RequestIdPolicyTests.this.mockResponse);
            }
        }).policies(new HttpPipelinePolicy[]{new RequestIdPolicy()}).build();
        pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
        pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
    }

    @Test
    public void sameRequestIdForRetry() throws Exception {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){
            String firstRequestId = null;

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                if (this.firstRequestId != null) {
                    String newRequestId = request.getHeaders().getValue(RequestIdPolicyTests.REQUEST_ID_HEADER);
                    Assertions.assertNotNull((Object)newRequestId);
                    Assertions.assertEquals((Object)newRequestId, (Object)this.firstRequestId);
                }
                this.firstRequestId = request.getHeaders().getValue(RequestIdPolicyTests.REQUEST_ID_HEADER);
                if (this.firstRequestId == null) {
                    Assertions.fail();
                }
                return Mono.just((Object)RequestIdPolicyTests.this.mockResponse);
            }
        }).policies(new HttpPipelinePolicy[]{new RequestIdPolicy(), new RetryPolicy((RetryStrategy)new FixedDelay(1, Duration.of(0L, ChronoUnit.SECONDS)))}).build();
        pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/"))).block();
    }
}

