/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.util.IterableStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import reactor.core.publisher.Flux;

public class IterableResponseTest {
    @BeforeEach
    public void init(TestInfo testInfo) {
        System.out.println("-------------- Running " + testInfo.getDisplayName() + " -----------------------------");
    }

    @Test
    public void testIterableResponseStreamFromStart() {
        IterableStream<Integer> iterableResponse = this.getIntegerIterableResponse(2, 5);
        Assertions.assertEquals((int)iterableResponse.stream().collect(Collectors.toList()).size(), (int)iterableResponse.stream().collect(Collectors.toList()).size());
        List<Integer> originalIntegerList = Arrays.asList(2, 3, 4, 5, 6);
        iterableResponse.stream().forEach(number -> Assertions.assertTrue((boolean)originalIntegerList.contains(number)));
    }

    @Test
    public void testIterableResponseIteratorFromStart() {
        IterableStream<Integer> iterableResponse = this.getIntegerIterableResponse(2, 5);
        ArrayList actualNumberValues1 = new ArrayList();
        ArrayList actualNumberValues2 = new ArrayList();
        iterableResponse.iterator().forEachRemaining(number -> actualNumberValues1.add(number));
        iterableResponse.iterator().forEachRemaining(number -> actualNumberValues2.add(number));
        Assertions.assertArrayEquals((Object[])actualNumberValues1.toArray(), (Object[])actualNumberValues2.toArray());
        List<Integer> originalIntegerList = Arrays.asList(2, 3, 4, 5, 6);
        iterableResponse.iterator().forEachRemaining(number -> Assertions.assertTrue((boolean)originalIntegerList.contains(number)));
    }

    private IterableStream<Integer> getIntegerIterableResponse(int startNumber, int noOfValues) {
        Flux integerFlux = Flux.range((int)startNumber, (int)noOfValues);
        return new IterableStream(integerFlux);
    }
}

