/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

public final class PagedFluxBaseJavaDocCodeSnippets {
    public void classDocSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.log().subscribe(item -> System.out.println("Processing item with value: " + item), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        pagedFluxBase.byPage().log().subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        String continuationToken = this.getContinuationToken();
        pagedFluxBase.byPage(continuationToken).log().doOnSubscribe(ignored -> System.out.println("Subscribed to paged flux processing pages starting from: " + continuationToken)).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
    }

    private PagedFluxBase<Integer, PagedResponse<Integer>> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        PagedFluxBase pagedFluxBase = new PagedFluxBase(firstPageRetriever, nextPageRetriever);
        Supplier<Mono> firstPageRetrieverFunction = () -> this.getFirstPage();
        PagedFluxBase pagedFluxBaseInstance = new PagedFluxBase(firstPageRetrieverFunction, nextPageRetriever);
        return pagedFluxBase;
    }

    public void byPageSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.byPage().log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing pages starting from first page")).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
        String continuationToken = this.getContinuationToken();
        pagedFluxBase.byPage(continuationToken).log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing page starting from " + continuationToken)).subscribe(page -> System.out.printf("Processing page containing item values: %s%n", page.getElements().stream().map(String::valueOf).collect(Collectors.joining(", "))), error -> System.err.println("An error occurred: " + error), () -> System.out.println("Processing complete."));
    }

    public void byTSnippet() {
        PagedFluxBase<Integer, PagedResponse<Integer>> pagedFluxBase = this.createAnInstance();
        pagedFluxBase.subscribe((CoreSubscriber)new BaseSubscriber<Integer>(){

            protected void hookOnSubscribe(Subscription subscription) {
                System.out.println("Subscribed to paged flux processing items");
                super.hookOnSubscribe(subscription);
            }

            protected void hookOnNext(Integer value) {
                System.out.println("Processing item " + value);
            }

            protected void hookOnComplete() {
                System.out.println("Completed processing");
            }
        });
    }

    private String getContinuationToken() {
        return UUID.randomUUID().toString();
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return this.getPage(continuationToken);
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return this.getPage(null);
    }

    private Mono<PagedResponse<Integer>> getPage(String continuationToken) {
        boolean lastPage = Math.random() > 0.5;
        String nextContinuationToken = lastPage ? null : UUID.randomUUID().toString();
        int elementCount = (int)Math.ceil(Math.random() * 15.0);
        List elements = IntStream.range(elementCount, elementCount + elementCount).map(val -> (int)(Math.random() * (double)val)).boxed().collect(Collectors.toList());
        return Mono.just((Object)new PagedResponseBase(new HttpRequest(HttpMethod.GET, "https://requestUrl.com"), 200, new HttpHeaders(), elements, nextContinuationToken, null));
    }
}

