/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.paging.PageRetriever;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PagedFluxJavaDocCodeSnippets {
    public void classDocSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.log().subscribe(item -> System.out.println("Processing item " + item), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        pagedFlux.byPage().log().subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        String continuationToken = this.getContinuationToken();
        pagedFlux.byPage(continuationToken).log().doOnSubscribe(ignored -> System.out.println("Subscribed to paged flux processing pages starting from: " + continuationToken)).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
    }

    public PagedFlux<Integer> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        PagedFlux pagedFlux = new PagedFlux(firstPageRetriever, nextPageRetriever);
        Supplier<Mono> firstPageRetrieverFunction = () -> this.getFirstPage();
        PagedFlux pagedFluxInstance = new PagedFlux(firstPageRetrieverFunction, nextPageRetriever);
        return pagedFlux;
    }

    public void byPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.byPage().log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing pages starting from first page")).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
        String continuationToken = this.getContinuationToken();
        pagedFlux.byPage(continuationToken).log().doOnSubscribe(ignoredVal -> System.out.println("Subscribed to paged flux processing page starting from " + continuationToken)).subscribe(page -> System.out.println("Processing page containing " + page.getItems()), error -> System.err.println("Error occurred " + error), () -> System.out.println("Completed processing."));
    }

    public void byTSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        pagedFlux.subscribe((CoreSubscriber)new BaseSubscriber<Integer>(){

            protected void hookOnSubscribe(Subscription subscription) {
                System.out.println("Subscribed to paged flux processing items");
                super.hookOnSubscribe(subscription);
            }

            protected void hookOnNext(Integer value) {
                System.out.println("Processing item " + value);
            }

            protected void hookOnComplete() {
                System.out.println("Completed processing");
            }
        });
    }

    public void pagedFluxFromPagedFlux() {
        final PagedFlux<Integer> intPagedFlux = this.createAnInstance();
        final Function<PagedResponse, PagedResponse> responseMapper = intResponse -> new PagedResponseBase(intResponse.getRequest(), intResponse.getStatusCode(), intResponse.getHeaders(), intResponse.getValue().stream().map(intValue -> Integer.toString(intValue)).collect(Collectors.toList()), (String)intResponse.getContinuationToken(), null);
        Supplier<PageRetriever<String, PagedResponse<String>>> provider = new Supplier<PageRetriever<String, PagedResponse<String>>>(){

            @Override
            public PageRetriever<String, PagedResponse<String>> get() {
                return (continuationToken, pageSize) -> {
                    Flux flux = continuationToken == null ? intPagedFlux.byPage() : intPagedFlux.byPage(continuationToken);
                    return flux.map(responseMapper);
                };
            }
        };
        PagedFlux strPagedFlux = PagedFlux.create((Supplier)provider);
        final PagedFlux<Integer> pagedFlux = this.createAnInstance();
        Supplier<PageRetriever<String, PagedResponse<Integer>>> eprovider = new Supplier<PageRetriever<String, PagedResponse<Integer>>>(){

            @Override
            public PageRetriever<String, PagedResponse<Integer>> get() {
                return (continuationToken, pageSize) -> {
                    Flux flux = continuationToken == null ? pagedFlux.byPage() : pagedFlux.byPage(continuationToken);
                    return flux.onErrorMap(t -> new PaginationException((Throwable)t));
                };
            }
        };
        PagedFlux exceptionMappedPagedFlux = PagedFlux.create((Supplier)eprovider);
    }

    private String getContinuationToken() {
        return null;
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return null;
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return null;
    }

    class PaginationException
    extends RuntimeException {
        PaginationException(Throwable ex) {
            super(ex);
        }
    }
}

