/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.FluxUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;
import reactor.util.context.Context;

public class PagedFluxTest {
    private List<PagedResponse<Integer>> pagedResponses;
    private List<PagedResponse<String>> pagedStringResponses;

    @BeforeEach
    public void init(TestInfo testInfo) {
        System.out.println("-------------- Running " + testInfo.getDisplayName() + " -----------------------------");
    }

    @Test
    public void testEmptyResults() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(0);
        StepVerifier.create((Publisher)pagedFlux.log()).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.byPage().log()).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.byPage(null).log()).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToItems() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.log()).expectNext((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}).verifyComplete();
    }

    @Test
    public void testPagedFluxConverter() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf)).expectNext((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"}).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromStart() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage().log()).expectNext(this.pagedResponses.get(0), this.pagedResponses.get(1), this.pagedResponses.get(2), this.pagedResponses.get(3), this.pagedResponses.get(4)).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromStartWithConvertedType() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage().log()).expectNextCount(5L).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage().log()).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(0).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(1).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(2).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(3).getValue().equals(pagedResponse.getValue())).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(4).getValue().equals(pagedResponse.getValue())).verifyComplete();
    }

    @Test
    public void testPagedFluxSinglePageConvertedType() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage().log()).expectNextCount(1L).verifyComplete();
        StepVerifier.create((Publisher)pagedFlux.mapPage(String::valueOf).byPage().log()).expectNextMatches(pagedResponse -> this.pagedStringResponses.get(0).getValue().equals(pagedResponse.getValue())).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromContinuationToken() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage("3").log()).expectNext(this.pagedResponses.get(3), this.pagedResponses.get(4)).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithSinglePageResult() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.byPage().log()).expectNext(this.pagedResponses.get(0)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.byPage(null).log()).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(1);
        StepVerifier.create((Publisher)pagedFlux.log()).expectNext((Object)0, (Object)1, (Object)2).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithSinglePageResultWithoutNextPageRetriever() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create((Publisher)pagedFlux.byPage().log()).expectNext(this.pagedResponses.get(0)).verifyComplete();
        pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create((Publisher)pagedFlux.byPage(null).log()).verifyComplete();
        pagedFlux = this.getIntegerPagedFluxSinglePage();
        StepVerifier.create((Publisher)pagedFlux.log()).expectNext((Object)0, (Object)1, (Object)2).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesWithTwoPages() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create((Publisher)pagedFlux.byPage().log()).expectNext(this.pagedResponses.get(0), this.pagedResponses.get(1)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create((Publisher)pagedFlux.byPage("1").log()).expectNext(this.pagedResponses.get(1)).verifyComplete();
        pagedFlux = this.getIntegerPagedFlux(2);
        StepVerifier.create((Publisher)pagedFlux.log()).expectNext((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5).verifyComplete();
    }

    @Test
    public void testPagedFluxSubscribeToPagesFromNullContinuationToken() throws MalformedURLException {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(5);
        StepVerifier.create((Publisher)pagedFlux.byPage(null).log()).verifyComplete();
    }

    @Test
    public void testPagedFluxWithContext() throws Exception {
        CountDownLatch singlePageLatch = new CountDownLatch(1);
        PagedFlux pagedFlux = new PagedFlux(() -> FluxUtil.withContext(context -> {
            Assertions.assertNotNull((Object)context);
            Assertions.assertEquals((int)1, (int)context.getValues().size());
            Assertions.assertEquals((Object)"context", (Object)context.getData((Object)"hello").get().toString());
            singlePageLatch.countDown();
            return Mono.empty();
        }));
        CountDownLatch multiPageLatch = new CountDownLatch(2);
        pagedFlux.byPage().subscriberContext(Context.of((Object)"hello", (Object)"context")).subscribe(pagedResponse -> Assertions.assertTrue((boolean)(pagedResponse instanceof PagedResponse)));
        boolean completed = singlePageLatch.await(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)completed);
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        pagedFlux = new PagedFlux(() -> FluxUtil.withContext(context -> {
            Assertions.assertNotNull((Object)context);
            Assertions.assertEquals((int)1, (int)context.getValues().size());
            Assertions.assertEquals((Object)"context", (Object)context.getData((Object)"hello").get().toString());
            multiPageLatch.countDown();
            PagedResponseBase response = new PagedResponseBase(httpRequest, 200, httpHeaders, Collections.emptyList(), "0", null);
            return Mono.just((Object)response);
        }), continuationToken -> FluxUtil.withContext(context -> {
            Assertions.assertNotNull((Object)context);
            Assertions.assertEquals((int)1, (int)context.getValues().size());
            Assertions.assertEquals((Object)"context", (Object)context.getData((Object)"hello").get().toString());
            multiPageLatch.countDown();
            return Mono.empty();
        }));
        pagedFlux.byPage().subscriberContext(Context.of((Object)"hello", (Object)"context")).subscribe(pagedResponse -> Assertions.assertTrue((boolean)(pagedResponse instanceof PagedResponse)));
        completed = multiPageLatch.await(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)completed);
    }

    private PagedFlux<Integer> getIntegerPagedFlux(int noOfPages) throws MalformedURLException {
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        String deserializedHeaders = "header1,value1,header2,value2";
        this.pagedResponses = IntStream.range(0, noOfPages).boxed().map(i -> this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, (int)i, noOfPages)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, noOfPages).boxed().map(i -> this.createPagedResponseWithString(httpRequest, httpHeaders, deserializedHeaders, (int)i, noOfPages)).collect(Collectors.toList());
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private PagedFlux<Integer> getIntegerPagedFluxSinglePage() throws MalformedURLException {
        HttpHeaders httpHeaders = new HttpHeaders().put("header1", "value1").put("header2", "value2");
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, new URL("http://localhost"));
        String deserializedHeaders = "header1,value1,header2,value2";
        this.pagedResponses = IntStream.range(0, 1).boxed().map(i -> this.createPagedResponse(httpRequest, httpHeaders, deserializedHeaders, (int)i, 1)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, 1).boxed().map(i -> this.createPagedResponseWithString(httpRequest, httpHeaders, deserializedHeaders, (int)i, 1)).collect(Collectors.toList());
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)));
    }

    private PagedResponseBase<String, Integer> createPagedResponse(HttpRequest httpRequest, HttpHeaders httpHeaders, String deserializedHeaders, int i, int noOfPages) {
        return new PagedResponseBase(httpRequest, 200, httpHeaders, this.getItems(i), i < noOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private PagedResponseBase<String, String> createPagedResponseWithString(HttpRequest httpRequest, HttpHeaders httpHeaders, String deserializedHeaders, int i, int noOfPages) {
        return new PagedResponseBase(httpRequest, 200, httpHeaders, this.getStringItems(i), i < noOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken, List<PagedResponse<Integer>> pagedResponses) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        return Mono.just(pagedResponses.get(Integer.valueOf(continuationToken)));
    }

    private List<Integer> getItems(Integer i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().collect(Collectors.toList());
    }

    private List<String> getStringItems(Integer i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().map(val -> String.valueOf(val)).collect(Collectors.toList());
    }
}

