/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class PagedIterableJavaDocCodeSnippets {
    public void streamByPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        pagedIterableResponse.streamByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getItems().forEach(value -> System.out.printf("Response value is %d %n", value));
        });
    }

    public void iterateByPageSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        pagedIterableResponse.iterableByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getItems().forEach(value -> System.out.printf("Response value is %d %n", value));
        });
    }

    public void iterableByPageWhileSnippet() {
        PagedFlux<Integer> pagedFlux = this.createAnInstance();
        PagedIterable pagedIterableResponse = new PagedIterable(pagedFlux);
        for (PagedResponse resp : pagedIterableResponse.iterableByPage()) {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getItems().forEach(value -> System.out.printf("Response value is %d %n", value));
        }
    }

    public PagedFlux<Integer> createAnInstance() {
        Supplier<Mono> firstPageRetriever = () -> this.getFirstPage();
        Function<String, Mono> nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        PagedFlux pagedFlux = new PagedFlux(firstPageRetriever, nextPageRetriever);
        return pagedFlux;
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken) {
        return null;
    }

    private Mono<PagedResponse<Integer>> getFirstPage() {
        return null;
    }
}

