/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseConstructorsCache;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

final class ResponseConstructorsCacheLambdaMetaFactory {
    private final ClientLogger logger = new ClientLogger(ResponseConstructorsCache.class);
    private final Map<Class<?>, ResponseConstructor> cache = new ConcurrentHashMap();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    ResponseConstructorsCacheLambdaMetaFactory() {
    }

    ResponseConstructor get(Class<? extends Response<?>> responseClass) {
        return this.cache.computeIfAbsent(responseClass, this::locateResponseConstructor);
    }

    private ResponseConstructor locateResponseConstructor(Class<?> responseClass) {
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                if (paramCount == 3) {
                    MethodHandle ctrMethodHandle = LOOKUP.unreflectConstructor(constructor);
                    return new ResponseConstructor(3, LambdaMetafactory.metafactory(LOOKUP, "apply", ResponseFunc3.METHOD_TYPE, ResponseFunc3.SIGNATURE, ctrMethodHandle, ctrMethodHandle.type()).getTarget().invoke());
                }
                if (paramCount == 4) {
                    MethodHandle ctrMethodHandle = LOOKUP.unreflectConstructor(constructor);
                    return new ResponseConstructor(4, LambdaMetafactory.metafactory(LOOKUP, "apply", ResponseFunc4.METHOD_TYPE, ResponseFunc4.SIGNATURE, ctrMethodHandle, ctrMethodHandle.type()).getTarget().invoke());
                }
                MethodHandle ctrMethodHandle = LOOKUP.unreflectConstructor(constructor);
                return new ResponseConstructor(5, LambdaMetafactory.metafactory(LOOKUP, "apply", ResponseFunc5.METHOD_TYPE, ResponseFunc5.SIGNATURE, ctrMethodHandle, ctrMethodHandle.type()).getTarget().invoke());
            }
            catch (Throwable t) {
                throw this.logger.logExceptionAsError(new RuntimeException(t));
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface ResponseFunc5 {
        public static final MethodType SIGNATURE = MethodType.methodType(Object.class, HttpRequest.class, Integer.TYPE, HttpHeaders.class, Object.class, Object.class);
        public static final MethodType METHOD_TYPE = MethodType.methodType(ResponseFunc5.class);

        public Object apply(HttpRequest var1, int var2, HttpHeaders var3, Object var4, Object var5);
    }

    @FunctionalInterface
    private static interface ResponseFunc4 {
        public static final MethodType SIGNATURE = MethodType.methodType(Object.class, HttpRequest.class, Integer.TYPE, HttpHeaders.class, Object.class);
        public static final MethodType METHOD_TYPE = MethodType.methodType(ResponseFunc4.class);

        public Object apply(HttpRequest var1, int var2, HttpHeaders var3, Object var4);
    }

    @FunctionalInterface
    private static interface ResponseFunc3 {
        public static final MethodType SIGNATURE = MethodType.methodType(Object.class, HttpRequest.class, Integer.TYPE, HttpHeaders.class);
        public static final MethodType METHOD_TYPE = MethodType.methodType(ResponseFunc3.class);

        public Object apply(HttpRequest var1, int var2, HttpHeaders var3);
    }

    static final class ResponseConstructor {
        private final int parameterCount;
        private final Object responseFunc;

        private ResponseConstructor(int parameterCount, Object responseFunc) {
            this.parameterCount = parameterCount;
            this.responseFunc = responseFunc;
        }

        Mono<Response<?>> invoke(HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
            HttpResponse httpResponse = decodedResponse.getSourceResponse();
            HttpRequest httpRequest = httpResponse.getRequest();
            int responseStatusCode = httpResponse.getStatusCode();
            HttpHeaders responseHeaders = httpResponse.getHeaders();
            switch (this.parameterCount) {
                case 3: {
                    try {
                        return Mono.just((Object)((Response)((ResponseFunc3)this.responseFunc).apply(httpRequest, responseStatusCode, responseHeaders)));
                    }
                    catch (Throwable t) {
                        throw Exceptions.propagate((Throwable)t);
                    }
                }
                case 4: {
                    try {
                        return Mono.just((Object)((Response)((ResponseFunc4)this.responseFunc).apply(httpRequest, responseStatusCode, responseHeaders, bodyAsObject)));
                    }
                    catch (Throwable t) {
                        throw Exceptions.propagate((Throwable)t);
                    }
                }
                case 5: {
                    return decodedResponse.getDecodedHeaders().map(decodedHeaders -> {
                        try {
                            return (Response)((ResponseFunc5)this.responseFunc).apply(httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedHeaders);
                        }
                        catch (Throwable t) {
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }).switchIfEmpty(Mono.defer(() -> {
                        try {
                            return Mono.just((Object)((Response)((ResponseFunc5)this.responseFunc).apply(httpRequest, responseStatusCode, responseHeaders, bodyAsObject, null)));
                        }
                        catch (Throwable t) {
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }));
                }
            }
            return Mono.error((Throwable)new IllegalStateException("Response constructor with expected parameters not found."));
        }
    }
}

