/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseConstructorsCacheLambdaMetaFactory;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

class ResponseConstructorsNoCacheReflection {
    private final ClientLogger logger = new ClientLogger(ResponseConstructorsCacheLambdaMetaFactory.class);

    ResponseConstructorsNoCacheReflection() {
    }

    Constructor<? extends Response<?>> get(Class<? extends Response<?>> responseClass) {
        return this.locateResponseConstructor(responseClass);
    }

    private Constructor<? extends Response<?>> locateResponseConstructor(Class<?> responseClass) {
        Constructor<?>[] constructors = responseClass.getDeclaredConstructors();
        Arrays.sort(constructors, Comparator.comparing(Constructor::getParameterCount, (a, b) -> b - a));
        for (Constructor<?> constructor : constructors) {
            int paramCount = constructor.getParameterCount();
            if (paramCount < 3 || paramCount > 5) continue;
            try {
                return constructor;
            }
            catch (Throwable t) {
                throw this.logger.logExceptionAsError(new RuntimeException(t));
            }
        }
        return null;
    }

    Mono<Response<?>> invoke(Constructor<? extends Response<?>> constructor, HttpResponseDecoder.HttpDecodedResponse decodedResponse, Object bodyAsObject) {
        HttpResponse httpResponse = decodedResponse.getSourceResponse();
        HttpRequest httpRequest = httpResponse.getRequest();
        int responseStatusCode = httpResponse.getStatusCode();
        HttpHeaders responseHeaders = httpResponse.getHeaders();
        int paramCount = constructor.getParameterCount();
        switch (paramCount) {
            case 3: {
                try {
                    return Mono.just(constructor.newInstance(httpRequest, responseStatusCode, responseHeaders));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            case 4: {
                try {
                    return Mono.just(constructor.newInstance(httpRequest, responseStatusCode, responseHeaders, bodyAsObject));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            case 5: {
                return decodedResponse.getDecodedHeaders().map(decodedHeaders -> {
                    try {
                        return (Response)constructor.newInstance(httpRequest, responseStatusCode, responseHeaders, bodyAsObject, decodedHeaders);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }).switchIfEmpty(Mono.defer(() -> {
                    try {
                        return Mono.just((Object)((Response)constructor.newInstance(httpRequest, responseStatusCode, responseHeaders, bodyAsObject, null)));
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }));
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Response constructor with expected parameters not found."));
    }
}

