/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.FluxUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class RestProxyTests {
    private static final byte[] EXPECTED = new byte[]{0, 1, 2, 3, 4};

    @Test
    public void emptyRequestBody() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
        StepVerifier.create((Publisher)RestProxy.validateLength((HttpRequest)httpRequest)).verifyComplete();
    }

    @Test
    public void expectedBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED).setHeader("Content-Length", "5");
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
    }

    @Test
    public void unexpectedBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED);
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest.setHeader("Content-Length", "4"))).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof UnexpectedLengthException));
            Assertions.assertEquals((Object)"Request body emitted 5 bytes, more than the expected 4 bytes.", (Object)throwable.getMessage());
        });
        StepVerifier.create(RestProxyTests.collectRequest(httpRequest.setHeader("Content-Length", "6"))).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof UnexpectedLengthException));
            Assertions.assertEquals((Object)"Request body emitted 5 bytes, less than the expected 6 bytes.", (Object)throwable.getMessage());
        });
    }

    @Test
    public void multipleSubscriptionsToCheckBodyLength() {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost").setBody(EXPECTED).setHeader("Content-Length", "5");
        Flux verifierFlux = RestProxy.validateLength((HttpRequest)httpRequest);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)verifierFlux)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)verifierFlux)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])EXPECTED, (byte[])bytes)).verifyComplete();
    }

    private static Mono<byte[]> collectRequest(HttpRequest request) {
        return FluxUtil.collectBytesInByteBufferStream((Flux)RestProxy.validateLength((HttpRequest)request));
    }
}

