/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.rest.MissingRequiredAnnotationException;
import com.azure.core.http.rest.SwaggerInterfaceParser;
import com.azure.core.http.rest.SwaggerMethodParser;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SwaggerInterfaceParserTests {
    @Test
    public void hostWithNoHostAnnotation() {
        Assertions.assertThrows(MissingRequiredAnnotationException.class, () -> new SwaggerInterfaceParser(TestInterface1.class, null));
    }

    @Test
    public void hostWithNoServiceNameAnnotation() {
        Assertions.assertThrows(MissingRequiredAnnotationException.class, () -> new SwaggerInterfaceParser(TestInterface2.class, null));
    }

    @Test
    public void hostWithHostAnnotation() {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(TestInterface3.class, null);
        Assertions.assertEquals((Object)"https://management.azure.com", (Object)interfaceParser.getHost());
        Assertions.assertEquals((Object)"myService", (Object)interfaceParser.getServiceName());
    }

    @Test
    public void methodParser() {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(TestInterface4.class, null);
        Method testMethod3 = TestInterface4.class.getDeclaredMethods()[0];
        Assertions.assertEquals((Object)"testMethod4", (Object)testMethod3.getName());
        SwaggerMethodParser methodParser = interfaceParser.getMethodParser(testMethod3);
        Assertions.assertNotNull((Object)methodParser);
        Assertions.assertEquals((Object)"com.azure.core.http.rest.SwaggerInterfaceParserTests$TestInterface4.testMethod4", (Object)methodParser.getFullyQualifiedMethodName());
        SwaggerMethodParser methodDetails2 = interfaceParser.getMethodParser(testMethod3);
        Assertions.assertSame((Object)methodParser, (Object)methodDetails2);
    }

    @Host(value="https://azure.com")
    @ServiceInterface(name="myService")
    static interface TestInterface4 {
        @Get(value="my/url/path")
        @ExpectedResponses(value={200})
        public void testMethod4();
    }

    @Host(value="https://management.azure.com")
    @ServiceInterface(name="myService")
    static interface TestInterface3 {
    }

    @Host(value="https://management.azure.com")
    static interface TestInterface2 {
    }

    static interface TestInterface1 {
        public String testMethod1();
    }
}

