/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.serializer.HttpResponseBodyDecoder;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.IterableStream;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class HttpResponseBodyDecoderTests {
    private static final HttpRequest GET_REQUEST = new HttpRequest(HttpMethod.GET, "https://localhost");
    private static final HttpRequest HEAD_REQUEST = new HttpRequest(HttpMethod.HEAD, "https://localhost");

    @BeforeEach
    public void prepareForMocking() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void clearMocks() {
        Mockito.framework().clearInlineMocks();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidHttpResponseSupplier"})
    public void invalidHttpResponse(HttpResponse response) {
        Assertions.assertThrows(NullPointerException.class, () -> HttpResponseBodyDecoder.decode(null, (HttpResponse)response, null, null));
    }

    private static Stream<Arguments> invalidHttpResponseSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null}), Arguments.of((Object[])new Object[]{new MockHttpResponse(null, 200)}), Arguments.of((Object[])new Object[]{new MockHttpResponse(new HttpRequest(null, "https://example.com"), 200)}));
    }

    @ParameterizedTest
    @MethodSource(value={"errorResponseSupplier"})
    public void errorResponse(String body, HttpResponse httpResponse, HttpResponseDecodeData decodeData, boolean isEmpty, Object expected) {
        StepVerifier.FirstStep firstStep = StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode((String)body, (HttpResponse)httpResponse, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData));
        if (isEmpty) {
            firstStep.verifyComplete();
        } else {
            firstStep.assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
        }
    }

    private static Stream<Arguments> errorResponseSupplier() {
        UnexpectedExceptionInformation exceptionInformation = (UnexpectedExceptionInformation)Mockito.mock(UnexpectedExceptionInformation.class);
        Mockito.when((Object)exceptionInformation.getExceptionBodyType()).thenAnswer(invocation -> String.class);
        HttpResponseDecodeData noExpectedStatusCodes = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)noExpectedStatusCodes.getUnexpectedException(ArgumentMatchers.anyInt())).thenReturn((Object)exceptionInformation);
        HttpResponseDecodeData expectedStatusCodes = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)expectedStatusCodes.getExpectedStatusCodes()).thenReturn((Object)new int[]{202});
        Mockito.when((Object)expectedStatusCodes.getUnexpectedException(ArgumentMatchers.anyInt())).thenReturn((Object)exceptionInformation);
        MockHttpResponse emptyResponse = new MockHttpResponse(GET_REQUEST, 300, (Object)null);
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 300, "expected");
        MockHttpResponse wrongGoodResponse = new MockHttpResponse(GET_REQUEST, 200, "good response");
        return Stream.of(Arguments.of((Object[])new Object[]{null, emptyResponse, noExpectedStatusCodes, true, null}), Arguments.of((Object[])new Object[]{null, emptyResponse, expectedStatusCodes, true, null}), Arguments.of((Object[])new Object[]{null, response, noExpectedStatusCodes, false, "expected"}), Arguments.of((Object[])new Object[]{null, response, expectedStatusCodes, false, "expected"}), Arguments.of((Object[])new Object[]{"\"expected\"", emptyResponse, noExpectedStatusCodes, false, "expected"}), Arguments.of((Object[])new Object[]{"\"expected\"", emptyResponse, expectedStatusCodes, false, "expected"}), Arguments.of((Object[])new Object[]{"\"not expected\"", response, noExpectedStatusCodes, false, "not expected"}), Arguments.of((Object[])new Object[]{"\"not expected\"", response, expectedStatusCodes, false, "not expected"}), Arguments.of((Object[])new Object[]{null, wrongGoodResponse, expectedStatusCodes, false, "good response"}), Arguments.of((Object[])new Object[]{"\"bad response\"", wrongGoodResponse, expectedStatusCodes, false, "bad response"}), Arguments.of((Object[])new Object[]{"expected", emptyResponse, noExpectedStatusCodes, true, null}));
    }

    @Test
    public void ioExceptionInErrorDeserializationReturnsEmpty() throws IOException {
        JacksonAdapter ioExceptionThrower = (JacksonAdapter)Mockito.mock(JacksonAdapter.class);
        Mockito.when((Object)ioExceptionThrower.deserialize((String)ArgumentMatchers.any(), (Type)ArgumentMatchers.any(), (SerializerEncoding)ArgumentMatchers.any())).thenThrow(IOException.class);
        HttpResponseDecodeData noExpectedStatusCodes = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)noExpectedStatusCodes.getUnexpectedException(ArgumentMatchers.anyInt())).thenReturn((Object)new UnexpectedExceptionInformation(HttpResponseException.class));
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 300);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)ioExceptionThrower, (HttpResponseDecodeData)noExpectedStatusCodes)).verifyComplete();
    }

    @Test
    public void headRequestReturnsEmpty() {
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getExpectedStatusCodes()).thenReturn((Object)new int[]{200});
        MockHttpResponse response = new MockHttpResponse(HEAD_REQUEST, 200);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"nonDecodableResponseSupplier"})
    public void nonDecodableResponse(HttpResponseDecodeData decodeData) {
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).verifyComplete();
    }

    private static Stream<Arguments> nonDecodableResponseSupplier() {
        HttpResponseDecodeData nullReturnType = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)nullReturnType.getReturnType()).thenReturn(null);
        ParameterizedType fluxByteBuffer = HttpResponseBodyDecoderTests.mockParameterizedType(Flux.class, new Type[]{ByteBuffer.class});
        HttpResponseDecodeData fluxByteBufferReturnType = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)fluxByteBufferReturnType.getReturnType()).thenReturn((Object)fluxByteBuffer);
        ParameterizedType monoByteArray = HttpResponseBodyDecoderTests.mockParameterizedType(Mono.class, new Type[]{byte[].class});
        HttpResponseDecodeData monoByteArrayReturnType = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)monoByteArrayReturnType.getReturnType()).thenReturn((Object)monoByteArray);
        ParameterizedType voidTypeResponse = HttpResponseBodyDecoderTests.mockParameterizedType(ResponseBase.class, new Type[]{Integer.TYPE, Void.TYPE});
        HttpResponseDecodeData voidTypeResponseReturnType = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)voidTypeResponseReturnType.getReturnType()).thenReturn((Object)voidTypeResponse);
        ParameterizedType voidClassResponse = HttpResponseBodyDecoderTests.mockParameterizedType(ResponseBase.class, new Type[]{Integer.TYPE, Void.TYPE});
        HttpResponseDecodeData voidClassResponseReturnType = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)voidClassResponseReturnType.getReturnType()).thenReturn((Object)voidClassResponse);
        return Stream.of(Arguments.of((Object[])new Object[]{nullReturnType}), Arguments.of((Object[])new Object[]{fluxByteBufferReturnType}), Arguments.of((Object[])new Object[]{monoByteArrayReturnType}), Arguments.of((Object[])new Object[]{voidTypeResponseReturnType}), Arguments.of((Object[])new Object[]{voidClassResponseReturnType}));
    }

    @Test
    public void emptyResponseReturnsMonoEmpty() {
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200, (Object)null);
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getReturnType()).thenReturn(String.class);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"decodableResponseSupplier"})
    public void decodableResponse(HttpResponse response, HttpResponseDecodeData decodeData, Object expected) {
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    private static Stream<Arguments> decodableResponseSupplier() {
        HttpResponseDecodeData stringDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)stringDecodeData.getReturnType()).thenReturn(String.class);
        Mockito.when((Object)stringDecodeData.getReturnValueWireType()).thenReturn(String.class);
        MockHttpResponse stringResponse = new MockHttpResponse(GET_REQUEST, 200, "hello");
        HttpResponseDecodeData offsetDateTimeDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)offsetDateTimeDecodeData.getReturnType()).thenReturn(OffsetDateTime.class);
        Mockito.when((Object)offsetDateTimeDecodeData.getReturnValueWireType()).thenReturn(OffsetDateTime.class);
        OffsetDateTime offsetDateTimeNow = OffsetDateTime.now(ZoneOffset.UTC);
        MockHttpResponse offsetDateTimeResponse = new MockHttpResponse(GET_REQUEST, 200, offsetDateTimeNow);
        HttpResponseDecodeData dateTimeRfc1123DecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)dateTimeRfc1123DecodeData.getReturnType()).thenReturn(OffsetDateTime.class);
        Mockito.when((Object)dateTimeRfc1123DecodeData.getReturnValueWireType()).thenReturn(DateTimeRfc1123.class);
        DateTimeRfc1123 dateTimeRfc1123Now = new DateTimeRfc1123(offsetDateTimeNow);
        MockHttpResponse dateTimeRfc1123Response = new MockHttpResponse(GET_REQUEST, 200, dateTimeRfc1123Now);
        HttpResponseDecodeData unixTimeDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)unixTimeDecodeData.getReturnType()).thenReturn(OffsetDateTime.class);
        Mockito.when((Object)unixTimeDecodeData.getReturnValueWireType()).thenReturn(UnixTime.class);
        UnixTime unixTimeNow = new UnixTime(offsetDateTimeNow);
        MockHttpResponse unixTimeResponse = new MockHttpResponse(GET_REQUEST, 200, unixTimeNow);
        ParameterizedType stringList = HttpResponseBodyDecoderTests.mockParameterizedType(List.class, new Type[]{String.class});
        HttpResponseDecodeData stringListDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)stringListDecodeData.getReturnType()).thenReturn((Object)stringList);
        Mockito.when((Object)stringListDecodeData.getReturnValueWireType()).thenReturn(String.class);
        List<String> list = Arrays.asList("hello", "azure");
        MockHttpResponse stringListResponse = new MockHttpResponse(GET_REQUEST, 200, list);
        ParameterizedType mapStringString = HttpResponseBodyDecoderTests.mockParameterizedType(Map.class, new Type[]{String.class, String.class});
        HttpResponseDecodeData mapStringStringDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)mapStringStringDecodeData.getReturnType()).thenReturn((Object)mapStringString);
        Mockito.when((Object)mapStringStringDecodeData.getReturnValueWireType()).thenReturn(String.class);
        Map<String, String> map = Collections.singletonMap("hello", "azure");
        MockHttpResponse mapStringStringResponse = new MockHttpResponse(GET_REQUEST, 200, map);
        return Stream.of(Arguments.of((Object[])new Object[]{stringResponse, stringDecodeData, "hello"}), Arguments.of((Object[])new Object[]{offsetDateTimeResponse, offsetDateTimeDecodeData, offsetDateTimeNow}), Arguments.of((Object[])new Object[]{dateTimeRfc1123Response, dateTimeRfc1123DecodeData, new DateTimeRfc1123(dateTimeRfc1123Now.toString()).getDateTime()}), Arguments.of((Object[])new Object[]{unixTimeResponse, unixTimeDecodeData, new UnixTime(Long.parseLong(unixTimeNow.toString())).getDateTime()}), Arguments.of((Object[])new Object[]{stringListResponse, stringListDecodeData, list}), Arguments.of((Object[])new Object[]{mapStringStringResponse, mapStringStringDecodeData, map}));
    }

    @Test
    public void decodeListBase64UrlResponse() {
        ParameterizedType parameterizedType = HttpResponseBodyDecoderTests.mockParameterizedType(List.class, new Type[]{byte[].class});
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getReturnType()).thenReturn((Object)parameterizedType);
        Mockito.when((Object)decodeData.getReturnValueWireType()).thenReturn(Base64Url.class);
        List<Base64Url> base64Urls = Arrays.asList(new Base64Url("base"), new Base64Url("64"));
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200, base64Urls);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).assertNext(actual -> {
            Assertions.assertTrue((boolean)(actual instanceof List));
            List decoded = (List)actual;
            Assertions.assertEquals((int)2, (int)decoded.size());
            Assertions.assertArrayEquals((byte[])((Base64Url)base64Urls.get(0)).decodedBytes(), (byte[])((byte[])decoded.get(0)));
            Assertions.assertArrayEquals((byte[])((Base64Url)base64Urls.get(1)).decodedBytes(), (byte[])((byte[])decoded.get(1)));
        }).verifyComplete();
    }

    @Test
    public void decodePageResponse() {
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200, new Page<String>(){

            public IterableStream<String> getElements() {
                return IterableStream.of(null);
            }

            public String getContinuationToken() {
                return null;
            }
        });
        HttpResponseDecodeData pageDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)pageDecodeData.getReturnType()).thenReturn(String.class);
        Mockito.when((Object)pageDecodeData.getReturnValueWireType()).thenReturn(Page.class);
        HttpResponseDecodeData itemPageDecodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)itemPageDecodeData.getReturnType()).thenReturn(String.class);
        Mockito.when((Object)itemPageDecodeData.getReturnValueWireType()).thenReturn(ItemPage.class);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)pageDecodeData)).assertNext(actual -> {
            Assertions.assertTrue((boolean)(actual instanceof Page));
            Page page = (Page)actual;
            Assertions.assertFalse((boolean)page.getElements().iterator().hasNext());
            Assertions.assertNull((Object)page.getContinuationToken());
        }).verifyComplete();
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)itemPageDecodeData)).assertNext(actual -> {
            Assertions.assertTrue((boolean)(actual instanceof Page));
            Page page = (Page)actual;
            Assertions.assertFalse((boolean)page.getElements().iterator().hasNext());
            Assertions.assertNull((Object)page.getContinuationToken());
        }).verifyComplete();
    }

    @Test
    public void malformedBodyReturnsError() {
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200, (Object)null);
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getReturnType()).thenReturn(String.class);
        Mockito.when((Object)decodeData.getReturnValueWireType()).thenReturn(String.class);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode((String)"malformed JSON string", (HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).verifyError(HttpResponseException.class);
    }

    @Test
    public void ioExceptionReturnsError() throws IOException {
        MockHttpResponse response = new MockHttpResponse(GET_REQUEST, 200, "valid JSON string");
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getReturnType()).thenReturn(String.class);
        Mockito.when((Object)decodeData.getReturnValueWireType()).thenReturn(String.class);
        SerializerAdapter serializer = (SerializerAdapter)Mockito.mock(SerializerAdapter.class);
        Mockito.when((Object)serializer.deserialize((String)ArgumentMatchers.any(), (Type)ArgumentMatchers.any(), (SerializerEncoding)ArgumentMatchers.any())).thenThrow(IOException.class);
        StepVerifier.create((Publisher)HttpResponseBodyDecoder.decode(null, (HttpResponse)response, (SerializerAdapter)serializer, (HttpResponseDecodeData)decodeData)).verifyError(HttpResponseException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"decodeTypeSupplier"})
    public void decodeType(HttpResponse response, HttpResponseDecodeData data, Type expected) {
        Assertions.assertEquals((Object)expected, (Object)HttpResponseBodyDecoder.decodedType((HttpResponse)response, (HttpResponseDecodeData)data));
    }

    private static Stream<Arguments> decodeTypeSupplier() {
        MockHttpResponse badResponse = new MockHttpResponse(GET_REQUEST, 400);
        MockHttpResponse headResponse = new MockHttpResponse(HEAD_REQUEST, 200);
        MockHttpResponse getResponse = new MockHttpResponse(GET_REQUEST, 200);
        HttpResponseDecodeData badResponseData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)badResponseData.getUnexpectedException(ArgumentMatchers.anyInt())).thenReturn((Object)new UnexpectedExceptionInformation(HttpResponseException.class));
        HttpResponseDecodeData nonDecodable = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)nonDecodable.getReturnType()).thenReturn(Void.TYPE);
        HttpResponseDecodeData stringReturn = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)stringReturn.getReturnType()).thenReturn(String.class);
        ParameterizedType monoString = HttpResponseBodyDecoderTests.mockParameterizedType(Mono.class, new Type[]{String.class});
        HttpResponseDecodeData monoStringReturn = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)monoStringReturn.getReturnType()).thenReturn((Object)monoString);
        ParameterizedType responseString = HttpResponseBodyDecoderTests.mockParameterizedType(Response.class, new Type[]{String.class});
        HttpResponseDecodeData responseStringReturn = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)responseStringReturn.getReturnType()).thenReturn((Object)responseString);
        return Stream.of(Arguments.of((Object[])new Object[]{badResponse, badResponseData, Object.class}), Arguments.of((Object[])new Object[]{headResponse, Mockito.mock(HttpResponseDecodeData.class), null}), Arguments.of((Object[])new Object[]{getResponse, nonDecodable, null}), Arguments.of((Object[])new Object[]{getResponse, stringReturn, String.class}), Arguments.of((Object[])new Object[]{getResponse, monoStringReturn, String.class}), Arguments.of((Object[])new Object[]{getResponse, responseStringReturn, String.class}));
    }

    private static ParameterizedType mockParameterizedType(Type rawType, Type ... actualTypeArguments) {
        ParameterizedType parameterizedType = (ParameterizedType)Mockito.mock(ParameterizedType.class);
        Mockito.when((Object)parameterizedType.getRawType()).thenReturn((Object)rawType);
        Mockito.when((Object)parameterizedType.getActualTypeArguments()).thenReturn((Object)actualTypeArguments);
        return parameterizedType;
    }
}

