/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.HttpResponseHeaderDecoder;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.test.StepVerifier;

public class HttpResponseHeaderDecoderTests {
    @AfterEach
    public void clearMocks() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void nullHeaderTypeReturnsMonoEmpty() {
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getHeadersType()).thenReturn(null);
        StepVerifier.create((Publisher)HttpResponseHeaderDecoder.decode(null, null, (HttpResponseDecodeData)decodeData)).verifyComplete();
    }

    @Test
    public void ioExceptionIsMappedToHttpResponseException() throws IOException {
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getHeadersType()).thenReturn(MockHeaders.class);
        SerializerAdapter serializer = (SerializerAdapter)Mockito.mock(SerializerAdapter.class);
        Mockito.when((Object)serializer.deserialize((HttpHeaders)ArgumentMatchers.any(), (Type)ArgumentMatchers.any())).thenThrow(IOException.class);
        MockHttpResponse response = new MockHttpResponse(null, 200);
        StepVerifier.create((Publisher)HttpResponseHeaderDecoder.decode((HttpResponse)response, (SerializerAdapter)serializer, (HttpResponseDecodeData)decodeData)).verifyError(HttpResponseException.class);
    }

    @Test
    public void headersAreDeserializedToType() {
        HttpResponseDecodeData decodeData = (HttpResponseDecodeData)Mockito.mock(HttpResponseDecodeData.class);
        Mockito.when((Object)decodeData.getHeadersType()).thenReturn(MockHeaders.class);
        MockHttpResponse response = new MockHttpResponse(null, 200, new HttpHeaders().put("mock-a", "a"));
        StepVerifier.create((Publisher)HttpResponseHeaderDecoder.decode((HttpResponse)response, (SerializerAdapter)new JacksonAdapter(), (HttpResponseDecodeData)decodeData)).assertNext(actual -> {
            Assertions.assertTrue((boolean)(actual instanceof MockHeaders));
            MockHeaders mockHeaders = (MockHeaders)actual;
            Assertions.assertEquals(Collections.singletonMap("a", "a"), mockHeaders.getHeaderCollection());
        }).verifyComplete();
    }

    public static final class MockHeaders {
        @HeaderCollection(value="mock-")
        private Map<String, String> headerCollection;

        public Map<String, String> getHeaderCollection() {
            return this.headerCollection;
        }

        public void setHeaderCollection(Map<String, String> headerCollection) {
            this.headerCollection = headerCollection;
        }
    }
}

