/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Base64Util;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Base64UtilTests {
    @Test
    public void testEncodeAndDecode() {
        byte[] src = new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81};
        byte[] dst = Base64Util.encode((byte[])src);
        Assertions.assertTrue((boolean)Arrays.equals(Base64Util.decode((byte[])dst), src));
    }

    @Test
    public void testEncodeNullValue() {
        Assertions.assertNull((Object)Base64Util.encode(null));
    }

    @Test
    public void testDecodeNullValue() {
        Assertions.assertNull((Object)Base64Util.decode(null));
    }

    @Test
    public void testDecodeString() {
        byte[] src = new byte[]{65, 65, 69, 67, 65, 119, 81, 70, 66, 103, 99, 73, 67, 81};
        String dstString = Base64Util.encodeToString((byte[])src);
        Assertions.assertTrue((boolean)Arrays.equals(Base64Util.decodeString((String)dstString), src));
    }

    @Test
    public void testDecodeStringNullValue() {
        Assertions.assertNull((Object)Base64Util.decodeString(null));
    }

    @Test
    public void testEncodeURLWithoutPaddingNullValue() {
        Assertions.assertNull((Object)Base64Util.encodeURLWithoutPadding(null));
    }

    @Test
    public void testDecodeURLNullValue() {
        Assertions.assertNull((Object)Base64Util.decodeURL(null));
    }
}

