/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CoreUtilsTests {
    private static final byte[] BYTES = "Hello world!".getBytes(StandardCharsets.UTF_8);
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};
    private static final byte[] UTF_32BE_BOM = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF_32LE_BOM = new byte[]{-1, -2, 0, 0};

    @Test
    public void findFirstOfTypeEmptyArgs() {
        Assertions.assertNull((Object)CoreUtils.findFirstOfType(null, Integer.class));
    }

    @Test
    public void findFirstOfTypeWithOneOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected};
        Integer actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (Integer)actual);
    }

    @Test
    public void findFirstOfTypeWithMultipleOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected, 10};
        Integer actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (Integer)actual);
    }

    @Test
    public void findFirstOfTypeWithNoneOfType() {
        Object[] args = new Object[]{"string", "anotherString"};
        Assertions.assertNull((Object)CoreUtils.findFirstOfType((Object[])args, Integer.class));
    }

    @Test
    public void testProperties() {
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("version"));
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("name"));
        Assertions.assertTrue((boolean)((String)CoreUtils.getProperties((String)"azure-core.properties").get("version")).matches("\\d.\\d.\\d([-a-zA-Z0-9.])*"));
    }

    @Test
    public void testMissingProperties() {
        Assertions.assertNotNull((Object)CoreUtils.getProperties((String)"foo.properties"));
        Assertions.assertTrue((boolean)CoreUtils.getProperties((String)"foo.properties").isEmpty());
        Assertions.assertNull(CoreUtils.getProperties((String)"azure-core.properties").get("foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"bomAwareToStringSupplier"})
    public void bomAwareToString(byte[] bytes, String contentType, String expected) {
        Assertions.assertEquals((Object)expected, (Object)CoreUtils.bomAwareToString((byte[])bytes, (String)contentType));
    }

    private static Stream<Arguments> bomAwareToStringSupplier() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null}), Arguments.arguments((Object[])new Object[]{BYTES, null, new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{BYTES, "charset=UTF-16BE", new String(BYTES, StandardCharsets.UTF_16BE)}), Arguments.arguments((Object[])new Object[]{BYTES, "charset=invalid", new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), null, new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_16BE_BOM), null, new String(BYTES, StandardCharsets.UTF_16BE)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_16LE_BOM), null, new String(BYTES, StandardCharsets.UTF_16LE)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_32BE_BOM), null, new String(BYTES, Charset.forName("UTF-32BE"))}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_32LE_BOM), null, new String(BYTES, Charset.forName("UTF-32LE"))}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), "charset=UTF-8", new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), "charset=UTF-16BE", new String(BYTES, StandardCharsets.UTF_8)}));
    }

    private static byte[] addBom(byte[] arr1) {
        byte[] mergedArray = new byte[arr1.length + BYTES.length];
        System.arraycopy(arr1, 0, mergedArray, 0, arr1.length);
        System.arraycopy(BYTES, 0, mergedArray, arr1.length, BYTES.length);
        return mergedArray;
    }
}

