/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class FluxUtilTest {
    @Test
    public void testCallWithContextGetSingle() {
        String response = (String)this.getSingle().subscriberContext(reactor.util.context.Context.of((Object)"FirstName", (Object)"Foo", (Object)"LastName", (Object)"Bar")).block();
        Assertions.assertEquals((Object)"Hello, Foo Bar", (Object)response);
    }

    @Test
    public void testCallWithContextGetCollection() {
        List<String> expectedLines = Arrays.asList("Hello,", "Foo", "Bar");
        ArrayList actualLines = new ArrayList();
        this.getCollection().subscriberContext(reactor.util.context.Context.of((Object)"FirstName", (Object)"Foo", (Object)"LastName", (Object)"Bar")).doOnNext(actualLines::add).subscribe();
        Assertions.assertEquals(expectedLines, actualLines);
    }

    @Test
    public void testCallWithDefaultContextGetSingle() {
        String response = (String)this.getSingleWithContextAttributes().subscriberContext(reactor.util.context.Context.of((Object)"FirstName", (Object)"Foo")).block();
        Assertions.assertEquals((Object)"Hello, Foo additionalContextValue", (Object)response);
    }

    @Test
    public void toReactorContextNull() {
        Assertions.assertTrue((boolean)FluxUtil.toReactorContext(null).isEmpty());
    }

    @Test
    public void toReactorContextContextNone() {
        Assertions.assertTrue((boolean)FluxUtil.toReactorContext((Context)Context.NONE).isEmpty());
    }

    @Test
    public void toReactorContextCleansesNullValues() {
        Assertions.assertTrue((boolean)FluxUtil.toReactorContext((Context)new Context((Object)"key", null)).isEmpty());
    }

    @Test
    public void toReactorContext() {
        Context context = new Context((Object)"key1", (Object)"value1");
        reactor.util.context.Context reactorContext = FluxUtil.toReactorContext((Context)context);
        Assertions.assertEquals((int)1, (int)reactorContext.size());
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key1"));
        Assertions.assertEquals((Object)"value1", (Object)reactorContext.get((Object)"key1"));
        context = context.addData((Object)"key2", (Object)"value2").addData((Object)"key1", (Object)"value3");
        reactorContext = FluxUtil.toReactorContext((Context)context);
        Assertions.assertEquals((int)2, (int)reactorContext.size());
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key1"));
        Assertions.assertEquals((Object)"value3", (Object)reactorContext.get((Object)"key1"));
        Assertions.assertTrue((boolean)reactorContext.hasKey((Object)"key2"));
        Assertions.assertEquals((Object)"value2", (Object)reactorContext.get((Object)"key2"));
    }

    @Test
    public void testIsFluxByteBufferInvalidType() {
        Assertions.assertFalse((boolean)FluxUtil.isFluxByteBuffer(Mono.class));
    }

    @Test
    public void testIsFluxByteBufferValidType() throws Exception {
        Method method = FluxUtilTest.class.getMethod("mockReturnType", new Class[0]);
        Type returnType = method.getGenericReturnType();
        Assertions.assertTrue((boolean)FluxUtil.isFluxByteBuffer((Type)returnType));
    }

    @Test
    public void testToMono() {
        String testValue = "some value";
        SimpleResponse response = new SimpleResponse(new HttpRequest(HttpMethod.GET, "http://www.test.com"), 202, new HttpHeaders(), (Object)testValue);
        StepVerifier.create((Publisher)FluxUtil.toMono((Response)response)).assertNext(val -> Assertions.assertEquals((Object)val, (Object)testValue)).verifyComplete();
    }

    @Test
    public void testMonoError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.monoError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testFluxError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.fluxError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testPageFluxError() {
        String errMsg = "It is an error message";
        RuntimeException ex = new RuntimeException(errMsg);
        ClientLogger logger = new ClientLogger(FluxUtilTest.class);
        StepVerifier.create((Publisher)FluxUtil.pagedFluxError((ClientLogger)logger, (RuntimeException)ex)).verifyErrorMessage(errMsg);
    }

    @Test
    public void testWriteFile() throws Exception {
        String toReplace = "test";
        String original = "hello there";
        String target = "testo there";
        Flux body = Flux.just((Object)ByteBuffer.wrap(toReplace.getBytes(StandardCharsets.UTF_8)));
        File file = this.createFileIfNotExist();
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(original.getBytes(StandardCharsets.UTF_8));
        stream.close();
        try (AsynchronousFileChannel channel = AsynchronousFileChannel.open(file.toPath(), StandardOpenOption.WRITE);){
            FluxUtil.writeFile((Flux)body, (AsynchronousFileChannel)channel).block();
            byte[] outputStream = Files.readAllBytes(file.toPath());
            Assertions.assertArrayEquals((byte[])outputStream, (byte[])target.getBytes(StandardCharsets.UTF_8));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"toFluxByteBufferSupplier"})
    public void toFluxByteBuffer(InputStream inputStream, Integer chunkSize, byte[] expected) {
        Flux conversionFlux;
        Flux flux = conversionFlux = chunkSize == null ? FluxUtil.toFluxByteBuffer((InputStream)inputStream) : FluxUtil.toFluxByteBuffer((InputStream)inputStream, (int)chunkSize);
        if (inputStream == null || expected.length == 0) {
            StepVerifier.create((Publisher)conversionFlux).verifyComplete();
            return;
        }
        int unboxedChunkSize = chunkSize == null ? 4096 : chunkSize;
        AtomicLong requestCount = new AtomicLong((long)Math.ceil((double)expected.length / (double)unboxedChunkSize));
        ByteBuffer collectionBuffer = ByteBuffer.allocate(expected.length);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)conversionFlux)).thenRequest(requestCount.get()).thenConsumeWhile(bytes -> {
            collectionBuffer.put((byte[])bytes, collectionBuffer.position(), ((byte[])bytes).length);
            if (requestCount.decrementAndGet() == -1L) {
                Assertions.assertArrayEquals((byte[])expected, (byte[])collectionBuffer.array());
                return false;
            }
            return true;
        }).verifyComplete();
    }

    private static Stream<Arguments> toFluxByteBufferSupplier() {
        byte[] emptyBuffer = new byte[]{};
        byte[] singleRead = new byte[4096];
        byte[] multipleReads = new byte[8193];
        SecureRandom random = new SecureRandom();
        random.nextBytes(singleRead);
        random.nextBytes(multipleReads);
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, null, emptyBuffer}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(emptyBuffer), null, emptyBuffer}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(singleRead), null, singleRead}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(multipleReads), null, multipleReads}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(singleRead), 8192, singleRead}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(singleRead), 2048, singleRead}), Arguments.arguments((Object[])new Object[]{new ByteArrayInputStream(multipleReads), 5432, multipleReads}));
    }

    @Test
    public void toFluxByteBufferMultipleSubscriptions() {
        byte[] singleRead = new byte[4096];
        new SecureRandom().nextBytes(singleRead);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(singleRead);
        Flux conversionFlux = FluxUtil.toFluxByteBuffer((InputStream)inputStream);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)conversionFlux)).assertNext(actual -> Assertions.assertArrayEquals((byte[])singleRead, (byte[])actual)).verifyComplete();
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)conversionFlux)).assertNext(actual -> Assertions.assertArrayEquals((byte[])new byte[0], (byte[])actual)).verifyComplete();
    }

    @Test
    public void illegalToFluxByteBufferChunkSize() {
        StepVerifier.create((Publisher)FluxUtil.toFluxByteBuffer(null, (int)0)).verifyError(IllegalArgumentException.class);
        StepVerifier.create((Publisher)FluxUtil.toFluxByteBuffer(null, (int)-1)).verifyError(IllegalArgumentException.class);
    }

    @Test
    public void toFluxByteBufferSinkException() {
        InputStream inputStream = new InputStream(){

            @Override
            public int read() {
                return 0;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                throw new IOException("Error");
            }
        };
        StepVerifier.create((Publisher)FluxUtil.toFluxByteBuffer((InputStream)inputStream)).verifyError(IOException.class);
    }

    public Flux<ByteBuffer> mockReturnType() {
        return Flux.just((Object)ByteBuffer.wrap(new byte[0]));
    }

    private Mono<String> getSingle() {
        return FluxUtil.withContext(this::serviceCallSingle);
    }

    private Flux<String> getCollection() {
        return FluxUtil.fluxContext(this::serviceCallCollection);
    }

    private Mono<String> getSingleWithContextAttributes() {
        return FluxUtil.withContext(this::serviceCallWithContextMetadata, Collections.singletonMap("additionalContextKey", "additionalContextValue"));
    }

    private Mono<String> serviceCallSingle(Context context) {
        String msg = "Hello, " + context.getData((Object)"FirstName").orElse("Stranger") + " " + context.getData((Object)"LastName").orElse("");
        return Mono.just((Object)msg);
    }

    private Flux<String> serviceCallCollection(Context context) {
        String msg = "Hello, " + context.getData((Object)"FirstName").orElse("Stranger") + " " + context.getData((Object)"LastName").orElse("");
        return Flux.just((Object[])msg.split(" "));
    }

    private Mono<String> serviceCallWithContextMetadata(Context context) {
        String msg = "Hello, " + context.getData((Object)"FirstName").orElse("Stranger") + " " + context.getData((Object)"additionalContextKey").orElse("Not found");
        return Mono.just((Object)msg);
    }

    private File createFileIfNotExist() throws IOException {
        File file = new File("target/test1");
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        return file;
    }
}

