/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.IterableStream;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class IterableStreamTests {
    @Test
    public void requiresFlux() {
        Assertions.assertThrows(NullPointerException.class, () -> new IterableStream((Flux)null));
    }

    @Test
    public void requiresIterable() {
        Assertions.assertThrows(NullPointerException.class, () -> new IterableStream((Iterable)null));
    }

    @Test
    public void streamFlux() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        Flux flux = Flux.create(sink -> {
            for (String c : expected) {
                sink.next((Object)c);
            }
            sink.complete();
        }).subscribeOn(Schedulers.parallel());
        IterableStream iterableStream = new IterableStream(flux);
        Set<String> actual = iterableStream.stream().collect(Collectors.toSet());
        IterableStreamTests.assertSets(expected, actual);
    }

    @Test
    public void streamFluxMultipleTimes() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        Flux flux = Flux.create(sink -> {
            for (String c : expected) {
                sink.next((Object)c);
            }
            sink.complete();
        }).subscribeOn(Schedulers.single());
        IterableStream iterableStream = new IterableStream(flux);
        Set<String> actual = iterableStream.stream().collect(Collectors.toSet());
        Set<String> actual2 = iterableStream.stream().collect(Collectors.toSet());
        IterableStreamTests.assertSets(expected, actual);
        IterableStreamTests.assertSets(expected, actual2);
    }

    @Test
    public void iteratorFlux() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        Flux flux = Flux.create(sink -> {
            for (String c : expected) {
                sink.next((Object)c);
            }
            sink.complete();
        }).subscribeOn(Schedulers.parallel());
        IterableStream iterableStream = new IterableStream(flux);
        int counter = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter);
    }

    @Test
    public void iteratorFluxMultipleTimes() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        Flux flux = Flux.create(sink -> {
            for (String c : expected) {
                sink.next((Object)c);
            }
            sink.complete();
        }).subscribeOn(Schedulers.parallel());
        IterableStream iterableStream = new IterableStream(flux);
        int counter = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter);
        int counter2 = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter2;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter2);
    }

    @Test
    public void streamIterable() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        IterableStream iterableStream = new IterableStream(expected);
        Set<String> actual = iterableStream.stream().collect(Collectors.toSet());
        IterableStreamTests.assertSets(expected, actual);
    }

    @Test
    public void streamIterableMultipleTimes() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        IterableStream iterableStream = new IterableStream(expected);
        Set<String> actual = iterableStream.stream().collect(Collectors.toSet());
        Set<String> actual2 = iterableStream.stream().collect(Collectors.toSet());
        IterableStreamTests.assertSets(expected, actual);
        IterableStreamTests.assertSets(expected, actual2);
    }

    @Test
    public void iteratorIterable() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        IterableStream iterableStream = new IterableStream(expected);
        int counter = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter);
    }

    @Test
    public void iteratorIterableMultipleTimes() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("Something");
        expected.add("Foo");
        expected.add("Bar");
        IterableStream iterableStream = new IterableStream(expected);
        int counter = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter);
        int counter2 = 0;
        for (String actual : iterableStream) {
            Assertions.assertTrue((boolean)expected.contains(actual));
            ++counter2;
        }
        Assertions.assertEquals((int)expected.size(), (int)counter2);
    }

    private static void assertSets(Set<String> expected, Set<String> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        for (String str : expected) {
            Assertions.assertTrue((boolean)actual.contains(str));
        }
    }
}

