/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.DateTimeDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class DateTimeDeserializerTests {
    @ParameterizedTest
    @MethodSource(value={"deserializeOffsetDateTimeSupplier"})
    public void deserializeJson(String offsetDateTimeString, OffsetDateTime expected) throws IOException {
        JsonParser parser = (JsonParser)Mockito.mock(JsonParser.class);
        Mockito.when((Object)parser.getValueAsString()).thenReturn((Object)offsetDateTimeString);
        Assertions.assertEquals((Object)expected, (Object)new DateTimeDeserializer().deserialize(parser, null));
    }

    private static Stream<Arguments> deserializeOffsetDateTimeSupplier() {
        OffsetDateTime minValue = OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime unixEpoch = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        return Stream.of(Arguments.of((Object[])new Object[]{"0001-01-01T00:00:00", minValue}), Arguments.of((Object[])new Object[]{"0001-01-01T00:00:00Z", minValue}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00", unixEpoch}), Arguments.of((Object[])new Object[]{"1970-01-01T00:00:00Z", unixEpoch}));
    }
}

