/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.serializer.AnimalShelter;
import com.azure.core.util.serializer.AnimalWithTypeIdContainingDot;
import com.azure.core.util.serializer.ComposeTurtles;
import com.azure.core.util.serializer.DogWithTypeIdContainingDot;
import com.azure.core.util.serializer.FlattenableAnimalInfo;
import com.azure.core.util.serializer.Foo;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.NonEmptyAnimalWithTypeIdContainingDot;
import com.azure.core.util.serializer.RabbitWithTypeIdContainingDot;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TurtleWithTypeIdContainingDot;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import wiremock.com.google.common.collect.ImmutableList;

public class FlatteningSerializerTests {
    @Test
    public void canFlatten() throws Exception {
        Foo foo = new Foo();
        foo.bar("hello.world");
        ArrayList<String> baz = new ArrayList<String>();
        baz.add("hello");
        baz.add("hello.world");
        foo.baz(baz);
        HashMap<String, String> qux = new HashMap<String, String>();
        qux.put("hello", "world");
        qux.put("a.b", "c.d");
        qux.put("bar.a", "ttyy");
        qux.put("bar.b", "uuzz");
        foo.qux(qux);
        JacksonAdapter adapter = new JacksonAdapter();
        String serialized = adapter.serialize((Object)foo, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"$type\":\"foo\",\"properties\":{\"bar\":\"hello.world\",\"props\":{\"baz\":[\"hello\",\"hello.world\"],\"q\":{\"qux\":{\"hello\":\"world\",\"a.b\":\"c.d\",\"bar.b\":\"uuzz\",\"bar.a\":\"ttyy\"}}}}}", (Object)serialized);
        Foo deserialized = (Foo)adapter.deserialize(serialized, Foo.class, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"hello.world", (Object)deserialized.bar());
        Assertions.assertArrayEquals((Object[])new String[]{"hello", "hello.world"}, (Object[])deserialized.baz().toArray());
        Assertions.assertNotNull(deserialized.qux());
        Assertions.assertEquals((Object)"world", (Object)deserialized.qux().get("hello"));
        Assertions.assertEquals((Object)"c.d", (Object)deserialized.qux().get("a.b"));
        Assertions.assertEquals((Object)"ttyy", (Object)deserialized.qux().get("bar.a"));
        Assertions.assertEquals((Object)"uuzz", (Object)deserialized.qux().get("bar.b"));
    }

    @Test
    public void canSerializeMapKeysWithDotAndSlash() throws Exception {
        String serialized = new JacksonAdapter().serialize((Object)this.prepareSchoolModel(), SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"teacher\":{\"students\":{\"af.B/D\":{},\"af.B/C\":{}}},\"tags\":{\"foo.aa\":\"bar\",\"x.y\":\"zz\"},\"properties\":{\"name\":\"school1\"}}", (Object)serialized);
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDotAndNoProperties() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String rabbitSerialized = "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}";
        String shelterSerialized = "{\"properties\":{\"animalsInfo\":[{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}},{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}}]}}";
        AnimalWithTypeIdContainingDot rabbitDeserialized = (AnimalWithTypeIdContainingDot)adapter.deserialize(rabbitSerialized, AnimalWithTypeIdContainingDot.class, SerializerEncoding.JSON);
        Assertions.assertTrue((boolean)(rabbitDeserialized instanceof RabbitWithTypeIdContainingDot));
        Assertions.assertNotNull((Object)rabbitDeserialized);
        AnimalShelter shelterDeserialized = (AnimalShelter)adapter.deserialize(shelterSerialized, AnimalShelter.class, SerializerEncoding.JSON);
        Assertions.assertTrue((boolean)(shelterDeserialized instanceof AnimalShelter));
        Assertions.assertEquals((int)2, (int)shelterDeserialized.animalsInfo().size());
        for (FlattenableAnimalInfo animalInfo : shelterDeserialized.animalsInfo()) {
            Assertions.assertTrue((boolean)(animalInfo.animal() instanceof RabbitWithTypeIdContainingDot));
            Assertions.assertNotNull((Object)animalInfo.animal());
        }
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDot0() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        ArrayList<String> meals = new ArrayList<String>();
        meals.add("carrot");
        meals.add("apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        String serialized = adapter.serialize((Object)animalToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)adapter.deserialize(serialized, AnimalWithTypeIdContainingDot.class, SerializerEncoding.JSON);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbit = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull(rabbit.meals());
        Assertions.assertEquals((int)rabbit.meals().size(), (int)2);
    }

    @Test
    public void canHandleTypeWithTypeIdContainingDot1() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        ArrayList<String> meals = new ArrayList<String>();
        meals.add("carrot");
        meals.add("apple");
        RabbitWithTypeIdContainingDot rabbitToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        String serialized = adapter.serialize((Object)rabbitToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)adapter.deserialize(serialized, RabbitWithTypeIdContainingDot.class, SerializerEncoding.JSON);
        Assertions.assertTrue((boolean)(rabbitDeserialized instanceof RabbitWithTypeIdContainingDot));
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleTypeWithFlattenablePropertyAndTypeIdContainingDot0() throws IOException {
        DogWithTypeIdContainingDot animalToSerialize = new DogWithTypeIdContainingDot().withBreed("AKITA").withCuteLevel(10);
        JacksonAdapter adapter = new JacksonAdapter();
        String serialized = adapter.serialize((Object)animalToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10}}", "{\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10}}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)adapter.deserialize(serialized, AnimalWithTypeIdContainingDot.class, SerializerEncoding.JSON);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof DogWithTypeIdContainingDot));
        DogWithTypeIdContainingDot dogDeserialized = (DogWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull((Object)dogDeserialized);
        Assertions.assertEquals((Object)dogDeserialized.breed(), (Object)"AKITA");
        Assertions.assertEquals((Integer)dogDeserialized.cuteLevel(), (Integer)10);
    }

    @Test
    public void canHandleTypeWithFlattenablePropertyAndTypeIdContainingDot1() throws IOException {
        DogWithTypeIdContainingDot dogToSerialize = new DogWithTypeIdContainingDot().withBreed("AKITA").withCuteLevel(10);
        JacksonAdapter adapter = new JacksonAdapter();
        String serialized = adapter.serialize((Object)dogToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10}}", "{\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\",\"properties\":{\"cuteLevel\":10}}", "{\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\",\"breed\":\"AKITA\"}", "{\"properties\":{\"cuteLevel\":10},\"breed\":\"AKITA\",\"@odata.type\":\"#Favourite.Pet.DogWithTypeIdContainingDot\"}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        DogWithTypeIdContainingDot dogDeserialized = (DogWithTypeIdContainingDot)adapter.deserialize(serialized, DogWithTypeIdContainingDot.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)dogDeserialized);
        Assertions.assertEquals((Object)dogDeserialized.breed(), (Object)"AKITA");
        Assertions.assertEquals((Integer)dogDeserialized.cuteLevel(), (Integer)10);
    }

    @Test
    public void canHandleArrayOfTypeWithTypeIdContainingDot0() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        ArrayList<String> meals = new ArrayList<String>();
        meals.add("carrot");
        meals.add("apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        ArrayList<RabbitWithTypeIdContainingDot> animalsToSerialize = new ArrayList<RabbitWithTypeIdContainingDot>();
        animalsToSerialize.add(animalToSerialize);
        String serialized = adapter.serialize(animalsToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"[{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}]", "[{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}]"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        List animalsDeserialized = (List)adapter.deserialize(serialized, (Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{AnimalWithTypeIdContainingDot.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        }, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)animalsDeserialized);
        Assertions.assertEquals((int)1, (int)animalsDeserialized.size());
        AnimalWithTypeIdContainingDot animalDeserialized = (AnimalWithTypeIdContainingDot)animalsDeserialized.get(0);
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleArrayOfTypeWithTypeIdContainingDot1() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        ArrayList<String> meals = new ArrayList<String>();
        meals.add("carrot");
        meals.add("apple");
        RabbitWithTypeIdContainingDot rabbitToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        ArrayList<RabbitWithTypeIdContainingDot> rabbitsToSerialize = new ArrayList<RabbitWithTypeIdContainingDot>();
        rabbitsToSerialize.add(rabbitToSerialize);
        String serialized = adapter.serialize(rabbitsToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"[{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}]", "[{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}]"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        List rabbitsDeserialized = (List)adapter.deserialize(serialized, (Type)new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{RabbitWithTypeIdContainingDot.class};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        }, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)rabbitsDeserialized);
        Assertions.assertEquals((int)1, (int)rabbitsDeserialized.size());
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)rabbitsDeserialized.get(0);
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleComposedTypeWithTypeIdContainingDot0() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        ArrayList<String> meals = new ArrayList<String>();
        meals.add("carrot");
        meals.add("apple");
        RabbitWithTypeIdContainingDot animalToSerialize = new RabbitWithTypeIdContainingDot().withMeals(meals);
        FlattenableAnimalInfo animalInfoToSerialize = new FlattenableAnimalInfo().withAnimal(animalToSerialize);
        ImmutableList animalsInfoSerialized = ImmutableList.of((Object)animalInfoToSerialize);
        AnimalShelter animalShelterToSerialize = new AnimalShelter().withAnimalsInfo((List<FlattenableAnimalInfo>)animalsInfoSerialized);
        String serialized = adapter.serialize((Object)animalShelterToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"properties\":{\"animalsInfo\":[{\"animal\":{\"meals\":[\"carrot\",\"apple\"],\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\"}}]}}", "{\"properties\":{\"animalsInfo\":[{\"animal\":{\"@odata.type\":\"#Favourite.Pet.RabbitWithTypeIdContainingDot\",\"meals\":[\"carrot\",\"apple\"]}}]}}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        AnimalShelter shelterDeserialized = (AnimalShelter)adapter.deserialize(serialized, AnimalShelter.class, SerializerEncoding.JSON);
        Assertions.assertNotNull(shelterDeserialized.animalsInfo());
        Assertions.assertEquals((int)shelterDeserialized.animalsInfo().size(), (int)1);
        FlattenableAnimalInfo animalsInfoDeserialized = shelterDeserialized.animalsInfo().get(0);
        Assertions.assertTrue((boolean)(animalsInfoDeserialized.animal() instanceof RabbitWithTypeIdContainingDot));
        AnimalWithTypeIdContainingDot animalDeserialized = animalsInfoDeserialized.animal();
        Assertions.assertTrue((boolean)(animalDeserialized instanceof RabbitWithTypeIdContainingDot));
        RabbitWithTypeIdContainingDot rabbitDeserialized = (RabbitWithTypeIdContainingDot)animalDeserialized;
        Assertions.assertNotNull((Object)rabbitDeserialized);
        Assertions.assertNotNull(rabbitDeserialized.meals());
        Assertions.assertEquals((int)rabbitDeserialized.meals().size(), (int)2);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
        String serializedScalarWithTypeId = "{\"turtlesSet1Lead\":{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}}";
        composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedScalarWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet1Lead());
        Assertions.assertEquals((long)10L, (long)composedTurtleDeserialized.turtlesSet1Lead().size().intValue());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet1Lead().age().intValue());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithoutTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10 },{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
        String serializedScalarWithTypeId = "{\"turtlesSet1Lead\":{\"age\":100,\"size\":10 }}";
        composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedScalarWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet1Lead());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet1Lead().age().intValue());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleComposedSpecificPolymorphicTypeWithAndWithoutTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet1\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet1());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet1().size());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof TurtleWithTypeIdContainingDot));
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
        String serializedScalarWithTypeId = "{\"turtlesSet2Lead\":{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"}}";
        composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedScalarWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet2Lead());
        Assertions.assertNotNull((Object)(composedTurtleDeserialized.turtlesSet2Lead() instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertEquals((long)10L, (long)((TurtleWithTypeIdContainingDot)composedTurtleDeserialized.turtlesSet2Lead()).size().intValue());
        Assertions.assertEquals((long)100L, (long)composedTurtleDeserialized.turtlesSet2Lead().age().intValue());
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithoutTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10 },{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertFalse((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof NonEmptyAnimalWithTypeIdContainingDot));
        Assertions.assertFalse((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof NonEmptyAnimalWithTypeIdContainingDot));
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
        String serializedScalarWithTypeId = "{\"turtlesSet2Lead\":{\"age\":100,\"size\":10 }}";
        composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedScalarWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull((Object)composedTurtleDeserialized.turtlesSet2Lead());
        Assertions.assertNotNull((Object)(composedTurtleDeserialized.turtlesSet2Lead() instanceof NonEmptyAnimalWithTypeIdContainingDot));
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleComposedGenericPolymorphicTypeWithAndWithoutTypeId() throws IOException {
        JacksonAdapter adapter = new JacksonAdapter();
        String serializedCollectionWithTypeId = "{\"turtlesSet2\":[{\"age\":100,\"size\":10,\"@odata.type\":\"#Favourite.Pet.TurtleWithTypeIdContainingDot\"},{\"age\":200,\"size\":20 }]}";
        ComposeTurtles composedTurtleDeserialized = (ComposeTurtles)adapter.deserialize(serializedCollectionWithTypeId, ComposeTurtles.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)composedTurtleDeserialized);
        Assertions.assertNotNull(composedTurtleDeserialized.turtlesSet2());
        Assertions.assertEquals((int)2, (int)composedTurtleDeserialized.turtlesSet2().size());
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(0) instanceof TurtleWithTypeIdContainingDot));
        Assertions.assertTrue((boolean)(composedTurtleDeserialized.turtlesSet2().get(1) instanceof NonEmptyAnimalWithTypeIdContainingDot));
        adapter.serialize((Object)composedTurtleDeserialized, SerializerEncoding.JSON);
    }

    @Test
    public void canHandleEscapedProperties() throws IOException {
        FlattenedProduct productToSerialize = new FlattenedProduct();
        productToSerialize.withProductName("drink");
        productToSerialize.withPType("chai");
        JacksonAdapter adapter = new JacksonAdapter();
        String serialized = adapter.serialize((Object)productToSerialize, SerializerEncoding.JSON);
        String[] results = new String[]{"{\"properties\":{\"p.name\":\"drink\",\"type\":\"chai\"}}", "{\"properties\":{\"type\":\"chai\",\"p.name\":\"drink\"}}"};
        boolean found = false;
        for (String result : results) {
            if (!result.equals(serialized)) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found);
        FlattenedProduct productDeserialized = (FlattenedProduct)adapter.deserialize(serialized, FlattenedProduct.class, SerializerEncoding.JSON);
        Assertions.assertNotNull((Object)productDeserialized);
        Assertions.assertEquals((Object)productDeserialized.productName(), (Object)"drink");
        Assertions.assertEquals((Object)productDeserialized.productType, (Object)"chai");
    }

    private School prepareSchoolModel() {
        Teacher teacher = new Teacher();
        HashMap<String, Student> students = new HashMap<String, Student>();
        students.put("af.B/C", new Student());
        students.put("af.B/D", new Student());
        teacher.withStudents(students);
        School school = new School().withName("school1");
        school.withTeacher(teacher);
        HashMap<String, String> schoolTags = new HashMap<String, String>();
        schoolTags.put("foo.aa", "bar");
        schoolTags.put("x.y", "zz");
        school.withTags(schoolTags);
        return school;
    }

    @JsonFlatten
    public static class FlattenedProduct {
        @JsonProperty(value="properties.p\\.name")
        private String productName;
        @JsonProperty(value="properties.type")
        private String productType;

        public String productName() {
            return this.productName;
        }

        public FlattenedProduct withProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public String productType() {
            return this.productType;
        }

        public FlattenedProduct withPType(String productType) {
            this.productType = productType;
            return this;
        }
    }

    private class Teacher {
        @JsonProperty(value="students")
        private Map<String, Student> students;

        private Teacher() {
        }

        public Teacher withStudents(Map<String, Student> students) {
            this.students = students;
            return this;
        }
    }

    private class Student {
        private Student() {
        }
    }

    @JsonFlatten
    private class School {
        @JsonProperty(value="teacher")
        private Teacher teacher;
        @JsonProperty(value="properties.name")
        private String name;
        @JsonProperty(value="tags")
        private Map<String, String> tags;

        private School() {
        }

        public School withTeacher(Teacher teacher) {
            this.teacher = teacher;
            return this;
        }

        public School withName(String name) {
            this.name = name;
            return this;
        }

        public School withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }
    }
}

