/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JacksonAdapterTests {
    @Test
    public void emptyMap() throws IOException {
        HashMap map = new HashMap();
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithNullKey() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(null, null);
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndNullValue() throws IOException {
        MapHolder mapHolder = new MapHolder();
        mapHolder.map(new HashMap<String, String>());
        mapHolder.map().put("", null);
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"map\":{\"\":null}}", (Object)serializer.serialize((Object)mapHolder, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndEmptyValue() throws IOException {
        MapHolder mapHolder = new MapHolder();
        mapHolder.map = new HashMap<String, String>();
        mapHolder.map.put("", "");
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"map\":{\"\":\"\"}}", (Object)serializer.serialize((Object)mapHolder, SerializerEncoding.JSON));
    }

    @Test
    public void mapWithEmptyKeyAndNonEmptyValue() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("", "test");
        JacksonAdapter serializer = new JacksonAdapter();
        Assertions.assertEquals((Object)"{\"\":\"test\"}", (Object)serializer.serialize(map, SerializerEncoding.JSON));
    }

    @ParameterizedTest
    @MethodSource(value={"deserializeJsonSupplier"})
    public void deserializeJson(String json, OffsetDateTime expected) throws IOException {
        DateTimeWrapper wrapper = (DateTimeWrapper)JacksonAdapter.createDefaultSerializerAdapter().deserialize(json, DateTimeWrapper.class, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)expected, (Object)wrapper.getOffsetDateTime());
    }

    private static Stream<Arguments> deserializeJsonSupplier() {
        String jsonFormat = "{\"OffsetDateTime\":\"%s\"}";
        OffsetDateTime minValue = OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime unixEpoch = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        return Stream.of(Arguments.of((Object[])new Object[]{String.format("{\"OffsetDateTime\":\"%s\"}", "0001-01-01T00:00:00"), minValue}), Arguments.of((Object[])new Object[]{String.format("{\"OffsetDateTime\":\"%s\"}", "0001-01-01T00:00:00Z"), minValue}), Arguments.of((Object[])new Object[]{String.format("{\"OffsetDateTime\":\"%s\"}", "1970-01-01T00:00:00"), unixEpoch}), Arguments.of((Object[])new Object[]{String.format("{\"OffsetDateTime\":\"%s\"}", "1970-01-01T00:00:00Z"), unixEpoch}));
    }

    @ParameterizedTest
    @MethodSource(value={"deserializeXmlSupplier"})
    public void deserializeXml(String xml, OffsetDateTime expected) throws IOException {
        DateTimeWrapper wrapper = (DateTimeWrapper)JacksonAdapter.createDefaultSerializerAdapter().deserialize(xml, DateTimeWrapper.class, SerializerEncoding.XML);
        Assertions.assertEquals((Object)expected, (Object)wrapper.getOffsetDateTime());
    }

    private static Stream<Arguments> deserializeXmlSupplier() {
        String xmlFormat = "<Wrapper><OffsetDateTime>%s</OffsetDateTime></Wrapper>";
        OffsetDateTime minValue = OffsetDateTime.of(1, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        OffsetDateTime unixEpoch = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        return Stream.of(Arguments.of((Object[])new Object[]{String.format("<Wrapper><OffsetDateTime>%s</OffsetDateTime></Wrapper>", "0001-01-01T00:00:00"), minValue}), Arguments.of((Object[])new Object[]{String.format("<Wrapper><OffsetDateTime>%s</OffsetDateTime></Wrapper>", "0001-01-01T00:00:00Z"), minValue}), Arguments.of((Object[])new Object[]{String.format("<Wrapper><OffsetDateTime>%s</OffsetDateTime></Wrapper>", "1970-01-01T00:00:00"), unixEpoch}), Arguments.of((Object[])new Object[]{String.format("<Wrapper><OffsetDateTime>%s</OffsetDateTime></Wrapper>", "1970-01-01T00:00:00Z"), unixEpoch}));
    }

    @JacksonXmlRootElement(localName="Wrapper")
    private static class DateTimeWrapper {
        @JsonProperty(value="OffsetDateTime", required=true)
        private OffsetDateTime offsetDateTime;

        private DateTimeWrapper() {
        }

        public DateTimeWrapper setOffsetDateTime(OffsetDateTime offsetDateTime) {
            this.offsetDateTime = offsetDateTime;
            return this;
        }

        public OffsetDateTime getOffsetDateTime() {
            return this.offsetDateTime;
        }
    }

    @JacksonXmlRootElement(localName="XmlString")
    private static class XmlString {
        @JsonProperty(value="Value")
        private String value;

        private XmlString() {
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class MapHolder {
        @JsonInclude(content=JsonInclude.Include.ALWAYS)
        private Map<String, String> map = new HashMap<String, String>();

        private MapHolder() {
        }

        public Map<String, String> map() {
            return this.map;
        }

        public void map(Map<String, String> map) {
            this.map = map;
        }
    }
}

