/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.serializer.SerializerEncoding;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class SerializerEncodingTests {
    private static final String CONTENT_TYPE = "Content-Type";

    SerializerEncodingTests() {
    }

    @ParameterizedTest
    @ValueSource(strings={"application/xml", "application/atom+xml", "text/xml", "application/foo+XML", "TEXT/XML", "application/xml;charset=utf-8", "application/atom+xml; charset=utf-32"})
    void recognizeXml(String mimeType) {
        HttpHeaders headers = new HttpHeaders(Collections.singletonMap(CONTENT_TYPE, mimeType));
        Assertions.assertEquals((Object)SerializerEncoding.XML, (Object)SerializerEncoding.fromHeaders((HttpHeaders)headers));
    }

    @ParameterizedTest
    @ValueSource(strings={"application/json", "application/kv+json", "APPLICATION/JSON", "application/FOO+JSON", "application/json;charset=utf-8", "application/config+json; charset=utf-32"})
    void recognizeJson(String mimeType) {
        HttpHeaders headers = new HttpHeaders(Collections.singletonMap(CONTENT_TYPE, mimeType));
        Assertions.assertEquals((Object)SerializerEncoding.JSON, (Object)SerializerEncoding.fromHeaders((HttpHeaders)headers));
    }

    @Test
    void defaultNoContentType() {
        HttpHeaders headers = new HttpHeaders(Collections.singletonMap("Http-Method", "GET"));
        Assertions.assertEquals((Object)SerializerEncoding.JSON, (Object)SerializerEncoding.fromHeaders((HttpHeaders)headers));
    }

    @ParameterizedTest
    @ValueSource(strings={"application/binary", "invalid-mime-type"})
    void defaultUnsupportedType(String mimeType) {
        HttpHeaders headers = new HttpHeaders(Collections.singletonMap(CONTENT_TYPE, mimeType));
        Assertions.assertEquals((Object)SerializerEncoding.JSON, (Object)SerializerEncoding.fromHeaders((HttpHeaders)headers));
    }
}

