/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpClientProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public final class HttpClientProviders {
    private static HttpClientProvider defaultProvider;
    private static final String CANNOT_FIND_HTTP_CLIENT = "Cannot find any HttpClient provider on the classpath - unable to create a default HttpClient instance";

    private HttpClientProviders() {
    }

    public static HttpClient createInstance() {
        if (defaultProvider == null) {
            throw new IllegalStateException(CANNOT_FIND_HTTP_CLIENT);
        }
        return defaultProvider.createInstance();
    }

    public static List<HttpClient> getAllHttpClients() {
        ServiceLoader<HttpClientProvider> serviceLoader = ServiceLoader.load(HttpClientProvider.class);
        Iterator<HttpClientProvider> iterator = serviceLoader.iterator();
        ArrayList<HttpClient> allClients = new ArrayList<HttpClient>();
        while (iterator.hasNext()) {
            allClients.add(iterator.next().createInstance());
        }
        return allClients;
    }

    static {
        ServiceLoader<HttpClientProvider> serviceLoader = ServiceLoader.load(HttpClientProvider.class);
        Iterator<HttpClientProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            defaultProvider = it.next();
        }
    }
}

