/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class CoreUtils {
    private static final String COMMA = ",";
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final byte ZERO = 0;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([\\S]+)\\b", 2);

    private CoreUtils() {
    }

    public static byte[] clone(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static int[] clone(int[] source) {
        if (source == null) {
            return null;
        }
        int[] copy = new int[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static <T> T[] clone(T[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <T> String arrayToString(T[] array, Function<T, String> mapper) {
        if (CoreUtils.isNullOrEmpty(array)) {
            return null;
        }
        return Arrays.stream(array).map(mapper).collect(Collectors.joining(COMMA));
    }

    public static <T> T findFirstOfType(Object[] args, Class<T> clazz) {
        if (CoreUtils.isNullOrEmpty(args)) {
            return null;
        }
        for (Object arg : args) {
            if (!clazz.isInstance(arg)) continue;
            return clazz.cast(arg);
        }
        return null;
    }

    public static <T> Publisher<T> extractAndFetch(PagedResponse<T> page, Context context, BiFunction<String, Context, Publisher<T>> content) {
        String nextPageLink = (String)page.getContinuationToken();
        if (nextPageLink == null) {
            return Flux.fromIterable(page.getItems());
        }
        return Flux.fromIterable(page.getItems()).concatWith(content.apply(nextPageLink, context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getProperties(String propertiesFileName) {
        ClientLogger logger = new ClientLogger(CoreUtils.class);
        try (InputStream inputStream = CoreUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            logger.warning("Failed to get properties from " + propertiesFileName, ex);
        }
        return Collections.emptyMap();
    }

    public static String bomAwareToString(byte[] bytes, String contentType) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return new String(bytes, 3, bytes.length - 3, StandardCharsets.UTF_8);
        }
        if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return new String(bytes, 4, bytes.length - 4, UTF_32BE);
        }
        if (bytes.length >= 4 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            return new String(bytes, 4, bytes.length - 4, UTF_32LE);
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16BE);
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16LE);
        }
        if (!CoreUtils.isNullOrEmpty(contentType)) {
            try {
                Matcher charsetMatcher = CHARSET_PATTERN.matcher(contentType);
                if (charsetMatcher.find()) {
                    return new String(bytes, Charset.forName(charsetMatcher.group(1)));
                }
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

