/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.ChangeFeedProcessorBuilder;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class ChangeFeedEncryptionProcessorBuilder {
    private String hostName;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private Consumer<List<JsonNode>> encryptionConsumer;
    private CosmosEncryptionAsyncContainer feedContainer = null;
    private CosmosAsyncContainer leaseContainer = null;

    public ChangeFeedEncryptionProcessorBuilder hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ChangeFeedEncryptionProcessorBuilder feedContainer(CosmosEncryptionAsyncContainer feedContainer) {
        this.feedContainer = feedContainer;
        return this;
    }

    public ChangeFeedEncryptionProcessorBuilder leaseContainer(CosmosAsyncContainer leaseContainer) {
        this.leaseContainer = leaseContainer;
        return this;
    }

    public ChangeFeedEncryptionProcessorBuilder handleChanges(Consumer<List<JsonNode>> consumer) {
        this.encryptionConsumer = jsonNodes -> {
            List objectNodeMonoList = jsonNodes.stream().map(jsonNode -> {
                if (jsonNode.isObject()) {
                    return this.feedContainer.decryptResponseNode((JsonNode)((ObjectNode)jsonNode));
                }
                throw new IllegalStateException("Current operation not supported in change feed encryption");
            }).collect(Collectors.toList());
            Flux.concat(objectNodeMonoList).publishOn(Schedulers.boundedElastic()).collectList().doOnSuccess(consumer).block();
        };
        return this;
    }

    public ChangeFeedEncryptionProcessorBuilder options(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessor buildChangeFeedProcessor() {
        ChangeFeedProcessorBuilder changeFeedProcessorBuilder = new ChangeFeedProcessorBuilder().hostName(this.hostName).feedContainer(this.feedContainer.getCosmosAsyncContainer()).leaseContainer(this.leaseContainer).handleChanges(this.encryptionConsumer).options(this.changeFeedProcessorOptions);
        return changeFeedProcessorBuilder.buildChangeFeedProcessor();
    }
}

