/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption;

import com.azure.cosmos.CosmosClientEncryptionKey;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncDatabase;
import com.azure.cosmos.encryption.CosmosEncryptionContainer;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.EncryptionKeyWrapMetadata;
import com.azure.cosmos.util.CosmosPagedIterable;
import reactor.core.publisher.Mono;

public final class CosmosEncryptionDatabase {
    private final CosmosDatabase cosmosDatabase;
    private final CosmosEncryptionAsyncDatabase cosmosEncryptionAsyncDatabase;

    CosmosEncryptionDatabase(CosmosDatabase cosmosDatabase, CosmosEncryptionAsyncDatabase cosmosEncryptionAsyncDatabase) {
        this.cosmosDatabase = cosmosDatabase;
        this.cosmosEncryptionAsyncDatabase = cosmosEncryptionAsyncDatabase;
    }

    public CosmosClientEncryptionKey getClientEncryptionKey(String id) {
        return this.cosmosDatabase.getClientEncryptionKey(id);
    }

    public CosmosPagedIterable<CosmosClientEncryptionKeyProperties> readAllClientEncryptionKeys() {
        return this.cosmosDatabase.readAllClientEncryptionKeys();
    }

    public CosmosClientEncryptionKeyResponse createClientEncryptionKey(String clientEncryptionKeyId, String encryptionAlgorithm, EncryptionKeyWrapMetadata encryptionKeyWrapMetadata) {
        return this.blockClientEncryptionKeyResponse(this.cosmosEncryptionAsyncDatabase.createClientEncryptionKey(clientEncryptionKeyId, encryptionAlgorithm, encryptionKeyWrapMetadata));
    }

    public CosmosClientEncryptionKeyResponse rewrapClientEncryptionKey(String clientEncryptionKeyId, EncryptionKeyWrapMetadata newEncryptionKeyWrapMetadata) {
        return this.blockClientEncryptionKeyResponse(this.cosmosEncryptionAsyncDatabase.rewrapClientEncryptionKey(clientEncryptionKeyId, newEncryptionKeyWrapMetadata));
    }

    public CosmosDatabase getCosmosDatabase() {
        return this.cosmosDatabase;
    }

    public CosmosEncryptionContainer getCosmosEncryptionContainer(CosmosContainer container) {
        CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer = this.cosmosEncryptionAsyncDatabase.getCosmosEncryptionAsyncContainer(container.getId());
        return new CosmosEncryptionContainer(container, cosmosEncryptionAsyncContainer);
    }

    public CosmosEncryptionContainer getCosmosEncryptionContainer(String containerId) {
        CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer = this.cosmosEncryptionAsyncDatabase.getCosmosEncryptionAsyncContainer(containerId);
        CosmosContainer cosmosContainer = this.cosmosDatabase.getContainer(containerId);
        return new CosmosEncryptionContainer(cosmosContainer, cosmosEncryptionAsyncContainer);
    }

    private CosmosClientEncryptionKeyResponse blockClientEncryptionKeyResponse(Mono<CosmosClientEncryptionKeyResponse> cosmosClientEncryptionKeyResponseMono) {
        try {
            return (CosmosClientEncryptionKeyResponse)cosmosClientEncryptionKeyResponseMono.block();
        }
        catch (Exception ex) {
            if (ex instanceof CosmosException) {
                throw (CosmosException)ex;
            }
            throw ex;
        }
    }
}

