/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncClient;
import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.encryption.implementation.EncryptionProcessor;
import com.azure.cosmos.encryption.implementation.keyprovider.EncryptionKeyStoreProviderImpl;
import com.azure.cosmos.encryption.models.SqlQuerySpecWithEncryption;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class EncryptionImplementationBridgeHelpers {
    private static final Logger logger = LoggerFactory.getLogger(EncryptionImplementationBridgeHelpers.class);

    private static <T> void ensureClassLoaded(Class<T> classType) {
        try {
            Class.forName(classType.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error("cannot load class {}", (Object)classType.getName());
            throw new RuntimeException(e);
        }
    }

    public static final class CosmosEncryptionAsyncContainerHelper {
        private static CosmosEncryptionAsyncContainerAccessor accessor;

        private CosmosEncryptionAsyncContainerHelper() {
        }

        public static void setCosmosEncryptionAsyncContainerAccessor(CosmosEncryptionAsyncContainerAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosEncryptionAsyncContainer accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosEncryptionAsyncContainerAccessor getCosmosEncryptionAsyncContainerAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosEncryptionAsyncContainer accessor is not initialized!");
            }
            return accessor;
        }

        static {
            EncryptionImplementationBridgeHelpers.ensureClassLoaded(CosmosEncryptionAsyncContainer.class);
        }

        public static interface CosmosEncryptionAsyncContainerAccessor {
            public EncryptionProcessor getEncryptionProcessor(CosmosEncryptionAsyncContainer var1);
        }
    }

    public static final class CosmosEncryptionAsyncClientHelper {
        private static CosmosEncryptionAsyncClientAccessor accessor;

        private CosmosEncryptionAsyncClientHelper() {
        }

        public static void seCosmosEncryptionAsyncClientAccessor(CosmosEncryptionAsyncClientAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("CosmosEncryptionAsyncClient accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static CosmosEncryptionAsyncClientAccessor getCosmosEncryptionAsyncClientAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("CosmosEncryptionAsyncClient accessor is not initialized!");
            }
            return accessor;
        }

        static {
            EncryptionImplementationBridgeHelpers.ensureClassLoaded(CosmosEncryptionAsyncClient.class);
        }

        public static interface CosmosEncryptionAsyncClientAccessor {
            public Mono<CosmosClientEncryptionKeyProperties> getClientEncryptionPropertiesAsync(CosmosEncryptionAsyncClient var1, String var2, String var3, CosmosAsyncContainer var4, boolean var5);

            public Mono<CosmosContainerProperties> getContainerPropertiesAsync(CosmosEncryptionAsyncClient var1, CosmosAsyncContainer var2, boolean var3);

            public EncryptionKeyStoreProviderImpl getEncryptionKeyStoreProviderImpl(CosmosEncryptionAsyncClient var1);
        }
    }

    public static final class SqlQuerySpecWithEncryptionHelper {
        private static SqlQuerySpecWithEncryptionAccessor accessor;

        private SqlQuerySpecWithEncryptionHelper() {
        }

        public static void setSqlQuerySpecWithEncryptionAccessor(SqlQuerySpecWithEncryptionAccessor newAccessor) {
            if (accessor != null) {
                throw new IllegalStateException("SqlQuerySpecWithEncryption accessor already initialized!");
            }
            accessor = newAccessor;
        }

        public static SqlQuerySpecWithEncryptionAccessor getSqlQuerySpecWithEncryptionAccessor() {
            if (accessor == null) {
                throw new IllegalStateException("SqlQuerySpecWithEncryption accessor is not initialized!");
            }
            return accessor;
        }

        static {
            EncryptionImplementationBridgeHelpers.ensureClassLoaded(SqlQuerySpecWithEncryption.class);
        }

        public static interface SqlQuerySpecWithEncryptionAccessor {
            public HashMap<String, SqlParameter> getEncryptionParamMap(SqlQuerySpecWithEncryption var1);

            public Mono<Void> addEncryptionParameterAsync(SqlQuerySpecWithEncryption var1, String var2, SqlParameter var3, CosmosEncryptionAsyncContainer var4);

            public SqlQuerySpec getSqlQuerySpec(SqlQuerySpecWithEncryption var1);
        }
    }
}

