/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation;

import com.azure.cosmos.encryption.implementation.CachedEncryptionSettings;
import com.azure.cosmos.encryption.implementation.EncryptionImplementationBridgeHelpers;
import com.azure.cosmos.encryption.implementation.EncryptionProcessor;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.AeadAes256CbcHmac256EncryptionAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionKeyStoreProvider;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ProtectedDataEncryptionKey;
import com.azure.cosmos.encryption.models.CosmosEncryptionType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.models.ClientEncryptionIncludedPath;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosContainerProperties;
import java.security.InvalidKeyException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public final class EncryptionSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionSettings.class);
    private AsyncCache<String, CachedEncryptionSettings> encryptionSettingCacheByPropertyName = new AsyncCache();
    private String clientEncryptionKeyId;
    private Instant encryptionSettingTimeToLive;
    private ProtectedDataEncryptionKey dataEncryptionKey;
    private AeadAes256CbcHmac256EncryptionAlgorithm aeadAes256CbcHmac256EncryptionAlgorithm;
    private EncryptionType encryptionType;
    private String databaseRid;
    private static final EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.CosmosEncryptionAsyncClientAccessor cosmosEncryptionAsyncClientAccessor = EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncClientHelper.getCosmosEncryptionAsyncClientAccessor();

    public Mono<EncryptionSettings> getEncryptionSettingForPropertyAsync(String propertyName, EncryptionProcessor encryptionProcessor) {
        Mono settingsMono = this.encryptionSettingCacheByPropertyName.getAsync((Object)propertyName, null, () -> this.fetchCachedEncryptionSettingsAsync(propertyName, encryptionProcessor));
        return settingsMono.flatMap(cachedEncryptionSettings -> {
            if (cachedEncryptionSettings == null) {
                return Mono.empty();
            }
            if (cachedEncryptionSettings.getEncryptionSettingsExpiryUtc().isBefore(Instant.now())) {
                return this.encryptionSettingCacheByPropertyName.getAsync((Object)propertyName, cachedEncryptionSettings, () -> this.fetchCachedEncryptionSettingsAsync(propertyName, encryptionProcessor)).map(latestCachedEncryptionSettings -> cachedEncryptionSettings.getEncryptionSettings());
            }
            return Mono.just((Object)cachedEncryptionSettings.getEncryptionSettings());
        });
    }

    Mono<CachedEncryptionSettings> fetchCachedEncryptionSettingsAsync(String propertyName, EncryptionProcessor encryptionProcessor) {
        Mono<CosmosContainerProperties> containerPropertiesMono = cosmosEncryptionAsyncClientAccessor.getContainerPropertiesAsync(encryptionProcessor.getEncryptionCosmosClient(), encryptionProcessor.getCosmosAsyncContainer(), false);
        AtomicBoolean forceRefreshClientEncryptionKey = new AtomicBoolean(false);
        return containerPropertiesMono.flatMap(cosmosContainerProperties -> {
            if (cosmosContainerProperties.getClientEncryptionPolicy() != null) {
                for (ClientEncryptionIncludedPath propertyToEncrypt : cosmosContainerProperties.getClientEncryptionPolicy().getIncludedPaths()) {
                    if (!propertyToEncrypt.getPath().substring(1).equals(propertyName)) continue;
                    return cosmosEncryptionAsyncClientAccessor.getClientEncryptionPropertiesAsync(encryptionProcessor.getEncryptionCosmosClient(), propertyToEncrypt.getClientEncryptionKeyId(), this.databaseRid, encryptionProcessor.getCosmosAsyncContainer(), forceRefreshClientEncryptionKey.get()).publishOn(Schedulers.boundedElastic()).flatMap(keyProperties -> {
                        ProtectedDataEncryptionKey protectedDataEncryptionKey;
                        try {
                            protectedDataEncryptionKey = this.buildProtectedDataEncryptionKey((CosmosClientEncryptionKeyProperties)keyProperties, encryptionProcessor.getEncryptionKeyStoreProviderImpl(), propertyToEncrypt.getClientEncryptionKeyId());
                        }
                        catch (Exception ex) {
                            return Mono.error((Throwable)ex);
                        }
                        EncryptionSettings encryptionSettings = new EncryptionSettings();
                        encryptionSettings.setDatabaseRid(this.databaseRid);
                        encryptionSettings.encryptionSettingTimeToLive = Instant.now().plus(Duration.ofMinutes(60L));
                        encryptionSettings.clientEncryptionKeyId = propertyToEncrypt.getClientEncryptionKeyId();
                        encryptionSettings.dataEncryptionKey = protectedDataEncryptionKey;
                        EncryptionType encryptionType = EncryptionType.Plaintext;
                        switch (CosmosEncryptionType.get(propertyToEncrypt.getEncryptionType())) {
                            case DETERMINISTIC: {
                                encryptionType = EncryptionType.Deterministic;
                                break;
                            }
                            case RANDOMIZED: {
                                encryptionType = EncryptionType.Randomized;
                                break;
                            }
                            default: {
                                LOGGER.debug("Invalid encryption type {}", (Object)propertyToEncrypt.getEncryptionType());
                            }
                        }
                        try {
                            encryptionSettings = EncryptionSettings.create(encryptionSettings, encryptionType);
                        }
                        catch (MicrosoftDataEncryptionException e) {
                            return Mono.error((Throwable)e);
                        }
                        return Mono.just((Object)new CachedEncryptionSettings(encryptionSettings, encryptionSettings.encryptionSettingTimeToLive));
                    }).retryWhen(Retry.withThrowable(throwableFlux -> throwableFlux.flatMap(throwable -> {
                        InvalidKeyException invalidKeyException = (InvalidKeyException)Utils.as((Object)throwable, InvalidKeyException.class);
                        if (invalidKeyException != null && !forceRefreshClientEncryptionKey.get()) {
                            forceRefreshClientEncryptionKey.set(true);
                            return Mono.delay((Duration)Duration.ZERO).flux();
                        }
                        return Flux.error((Throwable)throwable);
                    })));
                }
            }
            return Mono.empty();
        });
    }

    ProtectedDataEncryptionKey buildProtectedDataEncryptionKey(CosmosClientEncryptionKeyProperties keyProperties, EncryptionKeyStoreProvider encryptionKeyStoreProvider, String keyId) throws Exception {
        KeyEncryptionKey keyEncryptionKey = KeyEncryptionKey.getOrCreate(keyProperties.getEncryptionKeyWrapMetadata().getName(), keyProperties.getEncryptionKeyWrapMetadata().getValue(), encryptionKeyStoreProvider, false);
        return ProtectedDataEncryptionKey.getOrCreate(keyId, keyEncryptionKey, keyProperties.getWrappedDataEncryptionKey());
    }

    String getClientEncryptionKeyId() {
        return this.clientEncryptionKeyId;
    }

    void setClientEncryptionKeyId(String clientEncryptionKeyId) {
        this.clientEncryptionKeyId = clientEncryptionKeyId;
    }

    AsyncCache<String, CachedEncryptionSettings> getEncryptionSettingCacheByPropertyName() {
        return this.encryptionSettingCacheByPropertyName;
    }

    Instant getEncryptionSettingTimeToLive() {
        return this.encryptionSettingTimeToLive;
    }

    void setEncryptionSettingTimeToLive(Instant encryptionSettingTimeToLive) {
        this.encryptionSettingTimeToLive = encryptionSettingTimeToLive;
    }

    ProtectedDataEncryptionKey getDataEncryptionKey() {
        return this.dataEncryptionKey;
    }

    void setDataEncryptionKey(ProtectedDataEncryptionKey dataEncryptionKey) {
        this.dataEncryptionKey = dataEncryptionKey;
    }

    public void setEncryptionSettingCacheByPropertyName(AsyncCache<String, CachedEncryptionSettings> encryptionSettingCacheByPropertyName) {
        this.encryptionSettingCacheByPropertyName = encryptionSettingCacheByPropertyName;
    }

    public AeadAes256CbcHmac256EncryptionAlgorithm getAeadAes256CbcHmac256EncryptionAlgorithm() {
        return this.aeadAes256CbcHmac256EncryptionAlgorithm;
    }

    void setAeadAes256CbcHmac256EncryptionAlgorithm(AeadAes256CbcHmac256EncryptionAlgorithm aeadAes256CbcHmac256EncryptionAlgorithm) {
        this.aeadAes256CbcHmac256EncryptionAlgorithm = aeadAes256CbcHmac256EncryptionAlgorithm;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getDatabaseRid() {
        return this.databaseRid;
    }

    public void setDatabaseRid(String databaseRid) {
        this.databaseRid = databaseRid;
    }

    void setEncryptionSettingForProperty(String propertyName, EncryptionSettings encryptionSettings, Instant expiryUtc) {
        CachedEncryptionSettings cachedEncryptionSettings = new CachedEncryptionSettings(encryptionSettings, expiryUtc);
        this.encryptionSettingCacheByPropertyName.set((Object)propertyName, (Object)cachedEncryptionSettings);
    }

    static EncryptionSettings create(EncryptionSettings settingsForKey, EncryptionType encryptionType) throws MicrosoftDataEncryptionException {
        EncryptionSettings encryptionSettings = new EncryptionSettings();
        encryptionSettings.setDatabaseRid(settingsForKey.getDatabaseRid());
        encryptionSettings.setClientEncryptionKeyId(settingsForKey.clientEncryptionKeyId);
        encryptionSettings.setDataEncryptionKey(settingsForKey.getDataEncryptionKey());
        encryptionSettings.setEncryptionSettingTimeToLive(settingsForKey.getEncryptionSettingTimeToLive());
        encryptionSettings.setEncryptionType(encryptionType);
        AeadAes256CbcHmac256EncryptionAlgorithm aeadAes256CbcHmac256Algorithm = AeadAes256CbcHmac256EncryptionAlgorithm.getOrCreate(settingsForKey.getDataEncryptionKey(), encryptionType);
        encryptionSettings.setAeadAes256CbcHmac256EncryptionAlgorithm(aeadAes256CbcHmac256Algorithm);
        return encryptionSettings;
    }
}

