/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.keyprovider;

import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionKeyStoreProvider;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.KeyEncryptionKeyAlgorithm;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;

public class EncryptionKeyStoreProviderImpl
extends EncryptionKeyStoreProvider {
    private final KeyEncryptionKeyResolver keyEncryptionKeyResolver;
    private final String keyEncryptionKeyProviderName;
    public static final String RSA_OAEP = "RSA-OAEP";

    public EncryptionKeyStoreProviderImpl(KeyEncryptionKeyResolver keyEncryptionKeyResolver, String keyEncryptionKeyProviderName) {
        this.keyEncryptionKeyResolver = keyEncryptionKeyResolver;
        this.keyEncryptionKeyProviderName = keyEncryptionKeyProviderName;
    }

    @Override
    public String getProviderName() {
        return this.keyEncryptionKeyProviderName;
    }

    @Override
    public byte[] unwrapKey(String encryptionKeyId, KeyEncryptionKeyAlgorithm algorithm, byte[] encryptedKey) {
        return this.keyEncryptionKeyResolver.buildKeyEncryptionKey(encryptionKeyId).unwrapKey(EncryptionKeyStoreProviderImpl.getNameForKeyEncryptionKeyAlgorithm(algorithm), encryptedKey);
    }

    @Override
    public byte[] wrapKey(String encryptionKeyId, KeyEncryptionKeyAlgorithm algorithm, byte[] key) {
        return this.keyEncryptionKeyResolver.buildKeyEncryptionKey(encryptionKeyId).wrapKey(EncryptionKeyStoreProviderImpl.getNameForKeyEncryptionKeyAlgorithm(algorithm), key);
    }

    @Override
    public byte[] sign(String encryptionKeyId, boolean allowEnclaveComputations) {
        return new byte[0];
    }

    @Override
    public boolean verify(String encryptionKeyId, boolean allowEnclaveComputations, byte[] signature) throws MicrosoftDataEncryptionException {
        throw new MicrosoftDataEncryptionException("The Verify operation is not supported. ");
    }

    private static String getNameForKeyEncryptionKeyAlgorithm(KeyEncryptionKeyAlgorithm keyEncryptionKeyAlgorithm) {
        if (keyEncryptionKeyAlgorithm == KeyEncryptionKeyAlgorithm.RSA_OAEP) {
            return RSA_OAEP;
        }
        throw new IllegalArgumentException(String.format("Unexpected algorithm '%s'", new Object[]{keyEncryptionKeyAlgorithm}));
    }
}

