/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.implementation.mdesrc.cryptography;

import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.DataEncryptionKey;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.ISerializer;

public abstract class EncryptionSettings {
    protected DataEncryptionKey dataEncryptionKey;
    protected EncryptionType encryptionType = EncryptionType.Randomized;

    public DataEncryptionKey getDataEncryptionKey() {
        return this.dataEncryptionKey;
    }

    protected void setDataEncryptionKey(DataEncryptionKey d) {
        if (null == d) {
            this.encryptionType = EncryptionType.Plaintext;
        }
        this.dataEncryptionKey = d;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    protected void setEncryptionType(EncryptionType e) {
        this.encryptionType = e;
    }

    public abstract ISerializer getSerializer();

    protected static EncryptionType getDefaultEncryptionType(DataEncryptionKey d) {
        return null == d ? EncryptionType.Plaintext : EncryptionType.Randomized;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof EncryptionSettings)) {
            return false;
        }
        if (null == this.dataEncryptionKey && null == ((EncryptionSettings)other).dataEncryptionKey) {
            return true;
        }
        if (null != this.dataEncryptionKey) {
            return this.dataEncryptionKey.equals(((EncryptionSettings)other).dataEncryptionKey) && this.encryptionType.equals((Object)((EncryptionSettings)other).encryptionType) && this.getSerializer().getClass() == ((EncryptionSettings)other).getSerializer().getClass();
        }
        return false;
    }
}

