/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.encryption.models;

import com.azure.cosmos.encryption.CosmosEncryptionAsyncContainer;
import com.azure.cosmos.encryption.implementation.EncryptionImplementationBridgeHelpers;
import com.azure.cosmos.encryption.implementation.EncryptionProcessor;
import com.azure.cosmos.encryption.implementation.EncryptionUtils;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.EncryptionType;
import com.azure.cosmos.encryption.implementation.mdesrc.cryptography.MicrosoftDataEncryptionException;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import reactor.core.publisher.Mono;

public final class SqlQuerySpecWithEncryption {
    private SqlQuerySpec sqlQuerySpec;
    private HashMap<String, SqlParameter> encryptionParamMap = new HashMap();
    private final EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncContainerHelper.CosmosEncryptionAsyncContainerAccessor cosmosEncryptionAsyncContainerAccessor = EncryptionImplementationBridgeHelpers.CosmosEncryptionAsyncContainerHelper.getCosmosEncryptionAsyncContainerAccessor();

    public SqlQuerySpecWithEncryption(SqlQuerySpec sqlQuerySpec) {
        this.sqlQuerySpec = sqlQuerySpec;
    }

    public void addEncryptionParameter(String path, SqlParameter sqlParameter) {
        this.encryptionParamMap.put(path, sqlParameter);
    }

    Mono<Void> addEncryptionParameterAsync(String path, SqlParameter sqlParameter, CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer) {
        if (StringUtils.isEmpty((CharSequence)path) || path.charAt(0) != '/' || path.lastIndexOf(47) != 0) {
            return Mono.empty();
        }
        List parameters = this.sqlQuerySpec.getParameters();
        if (parameters != null) {
            return this.cosmosEncryptionAsyncContainerAccessor.getEncryptionProcessor(cosmosEncryptionAsyncContainer).initEncryptionSettingsIfNotInitializedAsync().then(Mono.defer(() -> this.cosmosEncryptionAsyncContainerAccessor.getEncryptionProcessor(cosmosEncryptionAsyncContainer).getEncryptionSettings().getEncryptionSettingForPropertyAsync(sqlParameter.getName().substring(1), this.cosmosEncryptionAsyncContainerAccessor.getEncryptionProcessor(cosmosEncryptionAsyncContainer)).flatMap(encryptionSettings -> {
                if (encryptionSettings == null) {
                    return Mono.empty();
                }
                if (encryptionSettings.getEncryptionType() == EncryptionType.Randomized) {
                    return Mono.error((Throwable)new IllegalArgumentException(String.format("Path %s cannot be used in the query because of randomized encryption", path)));
                }
                try {
                    byte[] valueByte = EncryptionUtils.serializeJsonToByteArray(EncryptionUtils.getSimpleObjectMapper(), sqlParameter.getValue(Object.class));
                    JsonNode itemJObj = (JsonNode)Utils.parse((byte[])valueByte, JsonNode.class);
                    Pair<EncryptionProcessor.TypeMarker, byte[]> typeMarkerPair = EncryptionProcessor.toByteArray(itemJObj);
                    byte[] cipherText = encryptionSettings.getAeadAes256CbcHmac256EncryptionAlgorithm().encrypt((byte[])typeMarkerPair.getRight());
                    byte[] cipherTextWithTypeMarker = new byte[cipherText.length + 1];
                    cipherTextWithTypeMarker[0] = (byte)((EncryptionProcessor.TypeMarker)((Object)((Object)((Object)typeMarkerPair.getLeft())))).getValue();
                    System.arraycopy(cipherText, 0, cipherTextWithTypeMarker, 1, cipherText.length);
                    SqlParameter encryptedParameter = new SqlParameter(sqlParameter.getName(), (Object)cipherTextWithTypeMarker);
                    parameters.add(encryptedParameter);
                }
                catch (MicrosoftDataEncryptionException ex) {
                    return Mono.error((Throwable)ex);
                }
                return Mono.empty();
            })));
        }
        return Mono.empty();
    }

    HashMap<String, SqlParameter> getEncryptionParamMap() {
        return this.encryptionParamMap;
    }

    SqlQuerySpec getSqlQuerySpec() {
        return this.sqlQuerySpec;
    }

    static {
        EncryptionImplementationBridgeHelpers.SqlQuerySpecWithEncryptionHelper.setSqlQuerySpecWithEncryptionAccessor(new EncryptionImplementationBridgeHelpers.SqlQuerySpecWithEncryptionHelper.SqlQuerySpecWithEncryptionAccessor(){

            @Override
            public HashMap<String, SqlParameter> getEncryptionParamMap(SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption) {
                return sqlQuerySpecWithEncryption.getEncryptionParamMap();
            }

            @Override
            public Mono<Void> addEncryptionParameterAsync(SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption, String path, SqlParameter sqlParameter, CosmosEncryptionAsyncContainer cosmosEncryptionAsyncContainer) {
                return sqlQuerySpecWithEncryption.addEncryptionParameterAsync(path, sqlParameter, cosmosEncryptionAsyncContainer);
            }

            @Override
            public SqlQuerySpec getSqlQuerySpec(SqlQuerySpecWithEncryption sqlQuerySpecWithEncryption) {
                return sqlQuerySpecWithEncryption.getSqlQuerySpec();
            }
        });
    }
}

