/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionType;
import com.azure.cosmos.test.faultinjection.FaultInjectionEndpoints;
import com.azure.cosmos.test.faultinjection.FaultInjectionOperationType;
import com.azure.cosmos.test.implementation.ImplementationBridgeHelpers;

public final class FaultInjectionCondition {
    private final FaultInjectionEndpoints endpoints;
    private final FaultInjectionOperationType operationType;
    private final FaultInjectionConnectionType connectionType;
    private final String region;

    FaultInjectionCondition(FaultInjectionOperationType operationType, FaultInjectionConnectionType connectionType, String region, FaultInjectionEndpoints endpoints) {
        this.operationType = operationType;
        this.connectionType = this.isMetadataOperationType() ? FaultInjectionConnectionType.GATEWAY : connectionType;
        this.region = region;
        this.endpoints = endpoints;
    }

    public FaultInjectionEndpoints getEndpoints() {
        return this.endpoints;
    }

    public FaultInjectionOperationType getOperationType() {
        return this.operationType;
    }

    public FaultInjectionConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getRegion() {
        return this.region;
    }

    boolean isMetadataOperationType() {
        if (this.operationType == null) {
            return false;
        }
        return this.operationType == FaultInjectionOperationType.METADATA_REQUEST_PARTITION_KEY_RANGES || this.operationType == FaultInjectionOperationType.METADATA_REQUEST_ADDRESS_REFRESH || this.operationType == FaultInjectionOperationType.METADATA_REQUEST_CONTAINER || this.operationType == FaultInjectionOperationType.METADATA_REQUEST_QUERY_PLAN || this.operationType == FaultInjectionOperationType.METADATA_REQUEST_DATABASE_ACCOUNT;
    }

    public String toString() {
        return String.format("FaultInjectionCondition{ endpoints=%s, operationType=%s, connectionType=%s, region=%s }", new Object[]{this.endpoints, this.operationType, this.connectionType, this.region});
    }

    static void initialize() {
        ImplementationBridgeHelpers.FaultInjectionConditionHelper.setFaultInjectionConditionAccessor(faultInjectionCondition -> faultInjectionCondition.isMetadataOperationType());
    }

    static {
        FaultInjectionCondition.initialize();
    }
}

