/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionCondition;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionType;
import com.azure.cosmos.test.faultinjection.FaultInjectionEndpoints;
import com.azure.cosmos.test.faultinjection.FaultInjectionOperationType;

public final class FaultInjectionConditionBuilder {
    private FaultInjectionEndpoints endpoints;
    private FaultInjectionOperationType operationType;
    private String region;
    private FaultInjectionConnectionType connectionType = FaultInjectionConnectionType.DIRECT;

    public FaultInjectionConditionBuilder region(String region) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)region), (Object)"Argument 'region' can not be null nor empty");
        this.region = region;
        return this;
    }

    public FaultInjectionConditionBuilder operationType(FaultInjectionOperationType operationType) {
        Preconditions.checkNotNull((Object)((Object)operationType), (Object)"Argument 'operationType' can not be null");
        this.operationType = operationType;
        return this;
    }

    public FaultInjectionConditionBuilder connectionType(FaultInjectionConnectionType connectionType) {
        Preconditions.checkNotNull((Object)((Object)connectionType), (Object)"Argument 'connectionType' can not be null");
        this.connectionType = connectionType;
        return this;
    }

    public FaultInjectionConditionBuilder endpoints(FaultInjectionEndpoints endpoints) {
        Preconditions.checkNotNull((Object)endpoints, (Object)"Argument 'endpoints' can not be null");
        this.endpoints = endpoints;
        return this;
    }

    public FaultInjectionCondition build() {
        return new FaultInjectionCondition(this.operationType, this.connectionType, this.region, this.endpoints);
    }
}

