/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionErrorResult;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionErrorType;
import java.time.Duration;

public final class FaultInjectionConnectionErrorResultBuilder {
    private static final double DEFAULT_CONNECTION_THRESHOLD = 1.0;
    private final FaultInjectionConnectionErrorType connectionErrorType;
    private Duration interval;
    private Double threshold = 1.0;

    FaultInjectionConnectionErrorResultBuilder(FaultInjectionConnectionErrorType connectionErrorType) {
        Preconditions.checkNotNull((Object)((Object)connectionErrorType), (Object)"Argument 'connectionErrorType' can not be null");
        this.connectionErrorType = connectionErrorType;
    }

    public FaultInjectionConnectionErrorResultBuilder interval(Duration interval) {
        Preconditions.checkNotNull((Object)interval, (Object)"Argument 'interval' can not be null");
        this.interval = interval;
        return this;
    }

    public FaultInjectionConnectionErrorResultBuilder threshold(double threshold) {
        Preconditions.checkArgument((threshold > 0.0 && threshold <= 1.0 ? 1 : 0) != 0, (Object)"Argument 'threshold' should be between (0, 1]");
        this.threshold = threshold;
        return this;
    }

    public FaultInjectionConnectionErrorResult build() {
        Preconditions.checkNotNull((Object)((Object)this.connectionErrorType), (Object)"Argument 'connectionErrorType' can not be null");
        Preconditions.checkNotNull((Object)this.interval, (Object)"Argument 'interval' can not be null");
        return new FaultInjectionConnectionErrorResult(this.connectionErrorType, this.interval, this.threshold);
    }
}

