/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.test.faultinjection.FaultInjectionEndpoints;

public final class FaultInjectionEndpointBuilder {
    private static final int DEFAULT_REPLICA_COUNT = Integer.MAX_VALUE;
    private static final boolean DEFAULT_INCLUDE_PRIMARY = true;
    private final FeedRange feedRange;
    private int replicaCount;
    private boolean includePrimary;

    public FaultInjectionEndpointBuilder(FeedRange feedRange) {
        Preconditions.checkNotNull((Object)feedRange, (Object)"Argument 'feedRange' can not be null");
        this.feedRange = feedRange;
        this.replicaCount = Integer.MAX_VALUE;
        this.includePrimary = true;
    }

    public FaultInjectionEndpointBuilder replicaCount(int replicaCount) {
        Preconditions.checkArgument((replicaCount > 0 ? 1 : 0) != 0, (Object)"Argument 'replicaCount' can not be negative");
        this.replicaCount = replicaCount;
        return this;
    }

    public FaultInjectionEndpointBuilder includePrimary(boolean includePrimary) {
        this.includePrimary = includePrimary;
        return this;
    }

    public FaultInjectionEndpoints build() {
        return new FaultInjectionEndpoints(this.feedRange, this.replicaCount, this.includePrimary);
    }
}

