/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionCondition;
import com.azure.cosmos.test.faultinjection.IFaultInjectionResult;
import com.azure.cosmos.test.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.test.implementation.faultinjection.IFaultInjectionRuleInternal;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class FaultInjectionRule {
    private final FaultInjectionCondition condition;
    private final IFaultInjectionResult result;
    private final Duration duration;
    private final Duration startDelay;
    private final Integer hitLimit;
    private final String id;
    private boolean enabled;
    private IFaultInjectionRuleInternal effectiveRule;

    FaultInjectionRule(String id, Duration startDelay, Duration duration, Integer requestHitLimit, boolean enabled, FaultInjectionCondition condition, IFaultInjectionResult result) {
        Preconditions.checkNotNull((Object)condition, (Object)"Argument 'condition' can not be null");
        Preconditions.checkNotNull((Object)result, (Object)"Argument 'result' can not be null");
        this.id = id;
        this.startDelay = startDelay;
        this.duration = duration;
        this.hitLimit = requestHitLimit;
        this.enabled = enabled;
        this.condition = condition;
        this.result = result;
    }

    public FaultInjectionCondition getCondition() {
        return this.condition;
    }

    public IFaultInjectionResult getResult() {
        return this.result;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Duration getStartDelay() {
        return this.startDelay;
    }

    public Integer getHitLimit() {
        return this.hitLimit;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
        if (this.effectiveRule != null) {
            this.effectiveRule.disable();
        }
    }

    public long getHitCount() {
        return this.effectiveRule == null ? 0L : this.effectiveRule.getHitCount();
    }

    public Map<String, Long> getHitCountDetails() {
        return this.effectiveRule == null ? null : this.effectiveRule.getHitCountDetails();
    }

    public List<String> getAddresses() {
        return this.effectiveRule == null ? null : this.effectiveRule.getAddresses().stream().map(URI::toString).collect(Collectors.toList());
    }

    public List<String> getRegionEndpoints() {
        return this.effectiveRule == null ? null : this.effectiveRule.getRegionEndpoints().stream().map(URI::toString).collect(Collectors.toList());
    }

    void setEffectiveFaultInjectionRule(IFaultInjectionRuleInternal effectiveRule) {
        this.effectiveRule = effectiveRule;
    }

    public String toString() {
        return String.format("FaultInjectionRule{ condition=%s, result=%s, duration=%s, startDelay=%s, hitLimit=%s, id=%s, enabled=%s", this.condition, this.result, this.duration, this.startDelay, this.hitLimit, this.id, this.enabled);
    }

    static void initialize() {
        ImplementationBridgeHelpers.FaultInjectionRuleHelper.setFaultInjectionRuleAccessor((rule, ruleInternal) -> rule.setEffectiveFaultInjectionRule(ruleInternal));
    }

    static {
        FaultInjectionRule.initialize();
    }
}

