/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionCondition;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionErrorResult;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionType;
import com.azure.cosmos.test.faultinjection.FaultInjectionRule;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorResult;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorType;
import com.azure.cosmos.test.faultinjection.IFaultInjectionResult;
import com.azure.cosmos.test.implementation.ImplementationBridgeHelpers;
import java.time.Duration;

public final class FaultInjectionRuleBuilder {
    private final String id;
    private FaultInjectionCondition condition;
    private IFaultInjectionResult result;
    private Duration duration;
    private Duration startDelay;
    private Integer hitLimit;
    private boolean enabled = true;

    public FaultInjectionRuleBuilder(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (Object)"Argument 'id' can not be null or empty");
        this.id = id;
    }

    public FaultInjectionRuleBuilder condition(FaultInjectionCondition condition) {
        Preconditions.checkNotNull((Object)condition, (Object)"Argument 'condition' can not be null");
        this.condition = condition;
        return this;
    }

    public FaultInjectionRuleBuilder result(IFaultInjectionResult faultInjectionResult) {
        Preconditions.checkNotNull((Object)faultInjectionResult, (Object)"Argument 'faultInjectionResult' can not be null");
        this.result = faultInjectionResult;
        return this;
    }

    public FaultInjectionRuleBuilder duration(Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"Argument 'duration' can not be null");
        this.duration = duration;
        return this;
    }

    public FaultInjectionRuleBuilder startDelay(Duration startDelay) {
        Preconditions.checkNotNull((Object)startDelay, (Object)"Argument 'startDelay' can not be null");
        this.startDelay = startDelay;
        return this;
    }

    public FaultInjectionRuleBuilder hitLimit(int hitLimit) {
        Preconditions.checkArgument((hitLimit > 0 ? 1 : 0) != 0, (Object)"Argument 'hitLimit' should be larger than 0");
        this.hitLimit = hitLimit;
        return this;
    }

    public FaultInjectionRuleBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FaultInjectionRule build() {
        if (this.condition == null) {
            throw new IllegalArgumentException("Argument 'condition' can not be null");
        }
        if (this.result == null) {
            throw new IllegalArgumentException("Argument 'result' can not be null");
        }
        if (this.condition.getConnectionType() == FaultInjectionConnectionType.GATEWAY) {
            this.validateRuleOnGatewayConnection();
        }
        return new FaultInjectionRule(this.id, this.startDelay, this.duration, this.hitLimit, this.enabled, this.condition, this.result);
    }

    private void validateRuleOnGatewayConnection() {
        if (this.result == null) {
            throw new IllegalArgumentException("Argument 'result' can not be null");
        }
        if (this.result instanceof FaultInjectionConnectionErrorResult) {
            throw new IllegalArgumentException("FaultInjectionConnectionError result can not be configured for rule with gateway connection type.");
        }
        FaultInjectionServerErrorResult serverErrorResult = (FaultInjectionServerErrorResult)this.result;
        if (serverErrorResult.getServerErrorType() == FaultInjectionServerErrorType.GONE) {
            throw new IllegalArgumentException("Gone exception can not be injected for rule with gateway connection type");
        }
        if (serverErrorResult.getServerErrorType() == FaultInjectionServerErrorType.STALED_ADDRESSES_SERVER_GONE) {
            throw new IllegalArgumentException("STALED_ADDRESSES exception can not be injected for rule with gateway connection type");
        }
        if (ImplementationBridgeHelpers.FaultInjectionConditionHelper.getFaultInjectionConditionAccessor().isMetadataOperationType(this.condition) && serverErrorResult.getServerErrorType() != FaultInjectionServerErrorType.TOO_MANY_REQUEST && serverErrorResult.getServerErrorType() != FaultInjectionServerErrorType.RESPONSE_DELAY && serverErrorResult.getServerErrorType() != FaultInjectionServerErrorType.CONNECTION_DELAY) {
            throw new IllegalArgumentException("Error type " + (Object)((Object)serverErrorResult.getServerErrorType()) + " is not supported for rule with metadata request");
        }
    }
}

