/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.faultinjection;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorResult;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorType;
import java.time.Duration;

public final class FaultInjectionServerErrorResultBuilder {
    private final FaultInjectionServerErrorType serverErrorType;
    private int times = Integer.MAX_VALUE;
    private Duration delay;
    private Boolean suppressServiceRequests = null;

    FaultInjectionServerErrorResultBuilder(FaultInjectionServerErrorType serverErrorType) {
        this.serverErrorType = serverErrorType;
    }

    public FaultInjectionServerErrorResultBuilder times(int times) {
        this.times = times;
        return this;
    }

    public FaultInjectionServerErrorResultBuilder delay(Duration delay) {
        Preconditions.checkNotNull((Object)delay, (Object)"Argument 'delay' can not be null");
        if (this.serverErrorType == FaultInjectionServerErrorType.RESPONSE_DELAY || this.serverErrorType == FaultInjectionServerErrorType.CONNECTION_DELAY) {
            this.delay = delay;
        }
        return this;
    }

    public FaultInjectionServerErrorResultBuilder suppressServiceRequests(boolean suppressServiceRequests) {
        this.suppressServiceRequests = suppressServiceRequests;
        return this;
    }

    public FaultInjectionServerErrorResult build() {
        if ((this.serverErrorType == FaultInjectionServerErrorType.RESPONSE_DELAY || this.serverErrorType == FaultInjectionServerErrorType.CONNECTION_DELAY) && this.delay == null) {
            throw new IllegalArgumentException("Argument 'delay' is required for server error type " + (Object)((Object)this.serverErrorType));
        }
        if (this.serverErrorType == FaultInjectionServerErrorType.STALED_ADDRESSES_SERVER_GONE) {
            this.times = Integer.MAX_VALUE;
        }
        return new FaultInjectionServerErrorResult(this.serverErrorType, this.times, this.delay, this.suppressServiceRequests);
    }
}

