/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation;

import com.azure.cosmos.test.faultinjection.FaultInjectionCondition;
import com.azure.cosmos.test.faultinjection.FaultInjectionRule;
import com.azure.cosmos.test.implementation.faultinjection.IFaultInjectionRuleInternal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationBridgeHelpers {
    private static final Logger logger = LoggerFactory.getLogger(ImplementationBridgeHelpers.class);

    public static final class FaultInjectionConditionHelper {
        private static final AtomicBoolean faultInjectionConditionClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<FaultInjectionConditionAccessor> accessor = new AtomicReference();

        private FaultInjectionConditionHelper() {
        }

        public static FaultInjectionConditionAccessor getFaultInjectionConditionAccessor() {
            FaultInjectionConditionAccessor snapshot;
            if (!faultInjectionConditionClassLoaded.get()) {
                logger.debug("Initializing FaultInjectionConditionAccessor...");
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("FaultInjectionConditionAccessor is not initialized yet!");
                System.exit(8701);
            }
            return snapshot;
        }

        public static void setFaultInjectionConditionAccessor(FaultInjectionConditionAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("FaultInjectionConditionAccessor already initialized!");
            } else {
                logger.debug("Setting FaultInjectionConditionAccessor...");
                faultInjectionConditionClassLoaded.set(true);
            }
        }

        public static interface FaultInjectionConditionAccessor {
            public boolean isMetadataOperationType(FaultInjectionCondition var1);
        }
    }

    public static final class FaultInjectionRuleHelper {
        private static final AtomicBoolean faultInjectionRuleClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<FaultInjectionRuleAccessor> accessor = new AtomicReference();

        private FaultInjectionRuleHelper() {
        }

        public static FaultInjectionRuleAccessor getFaultInjectionRuleAccessor() {
            FaultInjectionRuleAccessor snapshot;
            if (!faultInjectionRuleClassLoaded.get()) {
                logger.debug("Initializing FaultInjectionRuleAccessor...");
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("FaultInjectionRuleAccessor is not initialized yet!");
                System.exit(8700);
            }
            return snapshot;
        }

        public static void setFaultInjectionRuleAccessor(FaultInjectionRuleAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("FaultInjectionRuleAccessor already initialized!");
            } else {
                logger.debug("Setting FaultInjectionRuleAccessor...");
                faultInjectionRuleClassLoaded.set(true);
            }
        }

        public static interface FaultInjectionRuleAccessor {
            public void setEffectiveFaultInjectionRule(FaultInjectionRule var1, IFaultInjectionRuleInternal var2);
        }
    }
}

