/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation.faultinjection;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.PartitionIsMigratingException;
import com.azure.cosmos.implementation.PartitionKeyRangeIsSplittingException;
import com.azure.cosmos.implementation.RequestRateTooLargeException;
import com.azure.cosmos.implementation.RequestTimeoutException;
import com.azure.cosmos.implementation.RetryWithException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ServiceUnavailableException;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorType;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FaultInjectionServerErrorResultInternal {
    private final FaultInjectionServerErrorType serverErrorType;
    private final Integer times;
    private final Duration delay;
    private final Boolean suppressServiceRequests;

    public FaultInjectionServerErrorResultInternal(FaultInjectionServerErrorType serverErrorTypes, Integer times, Duration delay, Boolean suppressServiceRequests) {
        Preconditions.checkArgument((serverErrorTypes != null ? 1 : 0) != 0, (Object)"Argument 'serverErrorType' can not be null");
        this.serverErrorType = serverErrorTypes;
        this.times = times;
        this.delay = delay;
        this.suppressServiceRequests = suppressServiceRequests;
    }

    public FaultInjectionServerErrorType getServerErrorType() {
        return this.serverErrorType;
    }

    public Integer getTimes() {
        return this.times;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Boolean getSuppressServiceRequests() {
        return this.suppressServiceRequests;
    }

    public boolean isApplicable(String ruleId, RxDocumentServiceRequest request) {
        return this.times == null || request.faultInjectionRequestContext.getFaultInjectionRuleApplyCount(ruleId) < this.times;
    }

    public CosmosException getInjectedServerError(RxDocumentServiceRequest request) {
        RetryWithException cosmosException;
        long lsn = Long.parseLong(request.getHeaders().getOrDefault("lsn", "0"));
        String partitionKeyRangeId = request.getHeaders().getOrDefault("x-ms-documentdb-partitionkeyrangeid", null);
        Map<String, String> responseHeaders = this.getInjectedErrorResponseHeaders(request, lsn, partitionKeyRangeId);
        switch (this.serverErrorType) {
            case GONE: {
                GoneException goneException = new GoneException(this.getErrorMessage("The requested resource is no longer available at the server."), 21005);
                goneException.setIsBasedOn410ResponseFromService();
                cosmosException = goneException;
                break;
            }
            case RETRY_WITH: {
                cosmosException = new RetryWithException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case TOO_MANY_REQUEST: {
                responseHeaders.put("x-ms-retry-after-ms", String.valueOf(500));
                cosmosException = new RequestRateTooLargeException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case TIMEOUT: {
                RequestTimeoutException rootException = new RequestTimeoutException(null, lsn, partitionKeyRangeId, responseHeaders);
                cosmosException = new GoneException(null, null, lsn, partitionKeyRangeId, responseHeaders, (Throwable)rootException, 21010);
                break;
            }
            case INTERNAL_SERVER_ERROR: {
                cosmosException = new InternalServerErrorException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case READ_SESSION_NOT_AVAILABLE: {
                String badSessionToken = "1:1#1#1=1#1=1";
                responseHeaders.put("x-ms-substatus", Integer.toString(1002));
                responseHeaders.put("x-ms-session-token", "1:1#1#1=1#1=1");
                cosmosException = new NotFoundException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case PARTITION_IS_MIGRATING: {
                responseHeaders.put("x-ms-substatus", Integer.toString(1008));
                cosmosException = new PartitionIsMigratingException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case PARTITION_IS_SPLITTING: {
                responseHeaders.put("x-ms-substatus", Integer.toString(1007));
                cosmosException = new PartitionKeyRangeIsSplittingException(null, lsn, partitionKeyRangeId, responseHeaders);
                break;
            }
            case SERVICE_UNAVAILABLE: {
                responseHeaders.put("x-ms-substatus", Integer.toString(21008));
                cosmosException = new ServiceUnavailableException(null, null, null, 21008);
                break;
            }
            case STALED_ADDRESSES_SERVER_GONE: {
                GoneException staledAddressesException = new GoneException(this.getErrorMessage("The requested resource is no longer available at the server."), 21005);
                staledAddressesException.setIsBasedOn410ResponseFromService();
                cosmosException = staledAddressesException;
                break;
            }
            default: {
                throw new IllegalArgumentException("Server error type " + (Object)((Object)this.serverErrorType) + " is not supported");
            }
        }
        return cosmosException;
    }

    private Map<String, String> getInjectedErrorResponseHeaders(RxDocumentServiceRequest request, long lsn, String partitionKeyRangeId) {
        ConcurrentHashMap<String, String> responseHeaders = new ConcurrentHashMap<String, String>();
        String activityId = request.getActivityId().toString();
        String sessionToken = (String)request.getHeaders().get("x-ms-session-token");
        responseHeaders.put("x-ms-cosmos-llsn", String.valueOf(lsn));
        if (StringUtils.isNotEmpty((CharSequence)partitionKeyRangeId)) {
            responseHeaders.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeId);
        }
        if (StringUtils.isNotEmpty((CharSequence)activityId)) {
            responseHeaders.put("x-ms-activity-id", activityId);
        }
        if (StringUtils.isNotEmpty((CharSequence)sessionToken)) {
            responseHeaders.put("x-ms-session-token", sessionToken);
        }
        return responseHeaders;
    }

    private String getErrorMessage(String errorMessage) {
        return String.format("Fault injection server error [%s]", errorMessage);
    }
}

