/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation.faultinjection;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.faultinjection.FaultInjectionRequestArgs;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionType;
import com.azure.cosmos.test.faultinjection.FaultInjectionServerErrorType;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionConditionInternal;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionServerErrorResultInternal;
import com.azure.cosmos.test.implementation.faultinjection.IFaultInjectionRuleInternal;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class FaultInjectionServerErrorRule
implements IFaultInjectionRuleInternal {
    private final String id;
    private final Instant startTime;
    private final Instant expireTime;
    private final Integer hitLimit;
    private final AtomicLong hitCount;
    private final Map<String, Long> hitCountDetails;
    private final AtomicLong evaluationCount;
    private final FaultInjectionConnectionType connectionType;
    private final FaultInjectionConditionInternal condition;
    private final FaultInjectionServerErrorResultInternal result;
    private boolean enabled;

    public FaultInjectionServerErrorRule(String id, boolean enabled, Duration delay, Duration duration, Integer hitLimit, FaultInjectionConnectionType connectionType, FaultInjectionConditionInternal condition, FaultInjectionServerErrorResultInternal result) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (Object)"Argument 'id' cannot be null nor empty");
        Preconditions.checkNotNull((Object)condition, (Object)"Argument 'condition' can not be null");
        Preconditions.checkNotNull((Object)result, (Object)"Argument 'result' can not be null");
        Preconditions.checkNotNull((Object)((Object)connectionType), (Object)"Argument 'connectionType' can not be null");
        this.id = id;
        this.enabled = enabled;
        this.hitLimit = hitLimit;
        this.startTime = delay == null ? Instant.now() : Instant.now().plusMillis(delay.toMillis());
        this.expireTime = duration == null ? Instant.MAX : this.startTime.plusMillis(duration.toMillis());
        this.hitCount = new AtomicLong(0L);
        this.hitCountDetails = new ConcurrentHashMap<String, Long>();
        this.evaluationCount = new AtomicLong(0L);
        this.condition = condition;
        this.result = result;
        this.connectionType = connectionType;
    }

    public boolean isApplicable(FaultInjectionRequestArgs requestArgs) {
        boolean withinHitLimit;
        if (!this.isValid()) {
            requestArgs.getServiceRequest().faultInjectionRequestContext.recordFaultInjectionRuleEvaluation(requestArgs.getTransportRequestId(), String.format("%s[Disable or Duration reached. StartTime: %s, ExpireTime: %s]", this.id, this.startTime, this.expireTime));
            return false;
        }
        if (!this.condition.isApplicable(this.id, requestArgs)) {
            return false;
        }
        if (!this.result.isApplicable(this.id, requestArgs.getServiceRequest())) {
            requestArgs.getServiceRequest().faultInjectionRequestContext.recordFaultInjectionRuleEvaluation(requestArgs.getTransportRequestId(), this.id + "[Per operation apply limit reached]");
            return false;
        }
        if (this.result.getServerErrorType() == FaultInjectionServerErrorType.STALED_ADDRESSES_SERVER_GONE && requestArgs.getServiceRequest().faultInjectionRequestContext.getAddressForceRefreshed()) {
            requestArgs.getServiceRequest().faultInjectionRequestContext.recordFaultInjectionRuleEvaluation(requestArgs.getTransportRequestId(), "Address force refresh happened, STALED_ADDRESSES error is cleared.");
            return false;
        }
        long evaluationCount = this.evaluationCount.incrementAndGet();
        boolean bl = withinHitLimit = this.hitLimit == null || evaluationCount <= (long)this.hitLimit.intValue();
        if (!withinHitLimit) {
            requestArgs.getServiceRequest().faultInjectionRequestContext.recordFaultInjectionRuleEvaluation(requestArgs.getTransportRequestId(), String.format("%s [Hit Limit reached. Configured hitLimit %d, evaluationCount %d]", this.id, this.hitLimit, evaluationCount));
            return false;
        }
        this.hitCount.incrementAndGet();
        String name = requestArgs.getServiceRequest().getOperationType().toString() + "-" + requestArgs.getServiceRequest().getResourceType().toString();
        this.hitCountDetails.compute(name, (key, count) -> {
            if (count == null) {
                count = 0L;
            }
            Long l = count;
            count = count + 1L;
            return count;
        });
        return true;
    }

    public CosmosException getInjectedServerError(RxDocumentServiceRequest request) {
        return this.result.getInjectedServerError(request);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public Map<String, Long> getHitCountDetails() {
        return this.hitCountDetails;
    }

    @Override
    public FaultInjectionConnectionType getConnectionType() {
        return this.connectionType;
    }

    public FaultInjectionConditionInternal getCondition() {
        return this.condition;
    }

    public FaultInjectionServerErrorResultInternal getResult() {
        return this.result;
    }

    @Override
    public boolean isValid() {
        Instant now = Instant.now();
        return this.enabled && now.isAfter(this.startTime) && now.isBefore(this.expireTime);
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public List<URI> getAddresses() {
        return this.condition.getAddresses();
    }

    @Override
    public List<URI> getRegionEndpoints() {
        return this.condition.getRegionEndpoints();
    }
}

