/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation.faultinjection;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.faultinjection.IServerErrorInjector;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionRule;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionRuleStore;
import com.azure.cosmos.test.implementation.faultinjection.IFaultInjectionRuleInternal;
import com.azure.cosmos.test.implementation.faultinjection.RntbdConnectionErrorInjector;
import com.azure.cosmos.test.implementation.faultinjection.ServerErrorInjector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FaultInjectorProvider
implements IFaultInjectorProvider {
    private final Logger logger = LoggerFactory.getLogger(FaultInjectorProvider.class);
    private final FaultInjectionRuleStore ruleStore;
    private final IServerErrorInjector serverErrorInjector;
    private final String containerNameLink;
    private RntbdConnectionErrorInjector connectionErrorInjector;

    public FaultInjectorProvider(CosmosAsyncContainer cosmosAsyncContainer) {
        Preconditions.checkNotNull((Object)cosmosAsyncContainer, (Object)"Argument 'cosmosAsyncContainer' can not be null");
        this.containerNameLink = Utils.trimBeginningAndEndingSlashes((String)BridgeInternal.extractContainerSelfLink((CosmosAsyncContainer)cosmosAsyncContainer));
        this.ruleStore = new FaultInjectionRuleStore(cosmosAsyncContainer);
        this.serverErrorInjector = new ServerErrorInjector(this.ruleStore);
    }

    public Mono<Void> configureFaultInjectionRules(List<FaultInjectionRule> rules) {
        return Flux.fromIterable(rules).flatMap(rule -> this.ruleStore.configureFaultInjectionRule((FaultInjectionRule)rule, this.containerNameLink)).doOnNext(effectiveRule -> {
            if (this.connectionErrorInjector != null) {
                this.connectionErrorInjector.accept((IFaultInjectionRuleInternal)effectiveRule);
            }
        }).then();
    }

    public IServerErrorInjector getServerErrorInjector() {
        return this.serverErrorInjector;
    }

    public void registerConnectionErrorInjector(RntbdEndpoint.Provider provider) {
        this.connectionErrorInjector = new RntbdConnectionErrorInjector(provider, this.ruleStore);
    }
}

