/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation.faultinjection;

import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.faultinjection.RntbdFaultInjectionConnectionCloseEvent;
import com.azure.cosmos.implementation.faultinjection.RntbdFaultInjectionConnectionResetEvent;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.faultinjection.FaultInjectionConnectionType;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionConnectionErrorRule;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionRuleStore;
import com.azure.cosmos.test.implementation.faultinjection.IFaultInjectionRuleInternal;
import java.time.Duration;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RntbdConnectionErrorInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RntbdConnectionErrorInjector.class);
    private final RntbdEndpoint.Provider endpointProvider;
    private final FaultInjectionRuleStore ruleStore;

    public RntbdConnectionErrorInjector(RntbdEndpoint.Provider endpointProvider, FaultInjectionRuleStore ruleStore) {
        Preconditions.checkNotNull((Object)endpointProvider, (Object)"Argument 'endpointProvider' can not be null");
        Preconditions.checkNotNull((Object)ruleStore, (Object)"Argument 'ruleStore' can not be null");
        this.endpointProvider = endpointProvider;
        this.ruleStore = ruleStore;
    }

    public boolean accept(IFaultInjectionRuleInternal rule) {
        if (rule.getConnectionType() == FaultInjectionConnectionType.DIRECT && rule instanceof FaultInjectionConnectionErrorRule) {
            CosmosSchedulers.FAULT_INJECTION_CONNECTION_ERROR_BOUNDED_ELASTIC.schedule(() -> this.injectConnectionErrorTask((FaultInjectionConnectionErrorRule)rule).subscribe());
            return true;
        }
        return false;
    }

    public Mono<Void> injectConnectionErrorTask(FaultInjectionConnectionErrorRule rule) {
        return Mono.delay((Duration)rule.getResult().getInterval()).flatMapMany(t -> {
            if (this.isEffectiveRule(rule)) {
                rule.applyRule();
                if (rule.getAddresses() != null && rule.getAddresses().size() > 0) {
                    return Flux.fromIterable(rule.getAddresses()).flatMap(addressURI -> {
                        RntbdEndpoint rntbdEndpoint = this.endpointProvider.get(addressURI);
                        if (rntbdEndpoint != null) {
                            rntbdEndpoint.injectConnectionErrors(rule.getId(), rule.getResult().getThreshold(), this.getCloseEventType(rule));
                        }
                        return Mono.empty();
                    });
                }
                if (rule.getRegionEndpoints() != null && rule.getRegionEndpoints().size() > 0) {
                    return Flux.fromIterable(rule.getRegionEndpoints()).flatMap(regionEndpoint -> Flux.fromIterable((Iterable)this.endpointProvider.list().filter(rntbdEndpoint -> regionEndpoint.equals(rntbdEndpoint.serviceEndpoint())).collect(Collectors.toList())).flatMap(rntbdEndpoint -> {
                        rntbdEndpoint.injectConnectionErrors(rule.getId(), rule.getResult().getThreshold(), this.getCloseEventType(rule));
                        return Mono.empty();
                    }));
                }
                return Flux.fromIterable((Iterable)this.endpointProvider.list().collect(Collectors.toList())).flatMap(rntbdEndpoint -> {
                    rntbdEndpoint.injectConnectionErrors(rule.getId(), rule.getResult().getThreshold(), this.getCloseEventType(rule));
                    return Mono.empty();
                });
            }
            return Mono.empty();
        }).onErrorResume(throwable -> {
            LOGGER.warn("Inject connection error for rule [{}] failed due to", (Object)rule.getId(), throwable);
            return Mono.empty();
        }).repeat(() -> this.isEffectiveRule(rule)).then().doFinally(signalType -> this.ruleStore.removeRule(rule));
    }

    private Class<?> getCloseEventType(FaultInjectionConnectionErrorRule connectionErrorRule) {
        switch (connectionErrorRule.getResult().getErrorType()) {
            case CONNECTION_RESET: {
                return RntbdFaultInjectionConnectionResetEvent.class;
            }
            case CONNECTION_CLOSE: {
                return RntbdFaultInjectionConnectionCloseEvent.class;
            }
        }
        throw new IllegalArgumentException("Connection error type " + (Object)((Object)connectionErrorRule.getResult().getErrorType()) + " is not supported");
    }

    private boolean isEffectiveRule(FaultInjectionConnectionErrorRule rule) {
        return this.ruleStore.containsRule(rule) && rule.isValid();
    }
}

